/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.animation;

import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModel;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectSource;
import java.util.Arrays;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class AnimationEffectHandler {
    private final AnimationEffectSource source;
    private int[] soundId;

    public AnimationEffectHandler(AnimationEffectSource source) {
        this.source = source;
        this.reset();
    }

    public void reset() {
        this.soundId = new int[0];
    }

    @ApiStatus.Internal
    public void tick(class_2960[] animations, float animationTime) {
        if (this.soundId.length != animations.length) {
            this.soundId = new int[animations.length];
        }
        float animationLength = AnimatedModel.getAnimationLength(animationTime, (AnimationData[])Arrays.stream(animations).map(AnimationManager::getAnimation).toArray(AnimationData[]::new));
        int iteration = (int)(animationTime / animationLength);
        for (int i = 0; i < animations.length; ++i) {
            int oldId;
            AnimationData animation = AnimationManager.getAnimation(animations[i]);
            int soundId = this.soundId[i] - iteration * animation.getSoundEffects().length;
            if (soundId < 0 || soundId >= animation.getSoundEffects().length) continue;
            for (oldId = soundId; oldId < animation.getSoundEffects().length && animationTime >= animation.getSoundEffects()[oldId].getTime(); ++oldId) {
            }
            if (oldId == soundId) continue;
            AnimationData.SoundEffect soundEffect = animation.getSoundEffects()[oldId - 1];
            if (iteration == 0 || !soundEffect.isLoop()) {
                this.source.handleSoundEffect(animation, soundEffect);
            }
            this.soundId[i] = oldId;
        }
    }
}

