/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.animation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_3518;

public class AnimationData {
    public static final AnimationData EMPTY = new AnimationData("empty", Loop.NONE, MolangExpression.ZERO, 0.0f, false, new BoneAnimation[0], new SoundEffect[0], new ParticleEffect[0], new TimelineEffect[0]);
    private final String name;
    private final Loop loop;
    private final MolangExpression blendWeight;
    private final float animationLength;
    private final boolean overridePreviousAnimation;
    private final BoneAnimation[] boneAnimations;
    private final SoundEffect[] soundEffects;
    private final ParticleEffect[] particleEffects;
    private final TimelineEffect[] timelineEffects;

    public AnimationData(String name, Loop loop, MolangExpression blendWeight, float animationLength, boolean overridePreviousAnimation, BoneAnimation[] boneAnimations, SoundEffect[] soundEffects, ParticleEffect[] particleEffects, TimelineEffect[] timelineEffects) {
        this.name = name;
        this.loop = loop;
        this.blendWeight = blendWeight;
        this.animationLength = animationLength;
        this.overridePreviousAnimation = overridePreviousAnimation;
        this.boneAnimations = boneAnimations;
        this.soundEffects = soundEffects;
        this.particleEffects = particleEffects;
        this.timelineEffects = timelineEffects;
    }

    public String getName() {
        return this.name;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public MolangExpression getBlendWeight() {
        return this.blendWeight;
    }

    public float getAnimationLength() {
        return this.animationLength;
    }

    public boolean isOverridePreviousAnimation() {
        return this.overridePreviousAnimation;
    }

    public BoneAnimation[] getBoneAnimations() {
        return this.boneAnimations;
    }

    public SoundEffect[] getSoundEffects() {
        return this.soundEffects;
    }

    public ParticleEffect[] getParticleEffects() {
        return this.particleEffects;
    }

    public TimelineEffect[] getTimelineEffects() {
        return this.timelineEffects;
    }

    public String toString() {
        return "AnimationData{name='" + this.name + "', loop=" + this.loop + ", blendWeight=" + this.blendWeight + ", animationLength=" + this.animationLength + ", overridePreviousAnimation=" + this.overridePreviousAnimation + ", boneAnimations=" + Arrays.toString(this.boneAnimations) + ", soundEffects=" + Arrays.toString(this.soundEffects) + ", particleEffects=" + Arrays.toString(this.particleEffects) + ", timelineEffects=" + Arrays.toString(this.timelineEffects) + "}";
    }

    public static enum Loop {
        NONE,
        LOOP,
        HOLD_ON_LAST_FRAME;

    }

    public static class BoneAnimation {
        private final String name;
        private final KeyFrame[] positionFrames;
        private final KeyFrame[] rotationFrames;
        private final KeyFrame[] scaleFrames;

        public BoneAnimation(String name, KeyFrame[] positionFrames, KeyFrame[] rotationFrames, KeyFrame[] scaleFrames) {
            this.name = name;
            this.positionFrames = positionFrames;
            this.rotationFrames = rotationFrames;
            this.scaleFrames = scaleFrames;
        }

        public String getName() {
            return this.name;
        }

        public KeyFrame[] getPositionFrames() {
            return this.positionFrames;
        }

        public KeyFrame[] getRotationFrames() {
            return this.rotationFrames;
        }

        public KeyFrame[] getScaleFrames() {
            return this.scaleFrames;
        }

        public String toString() {
            return "BoneAnimation{name='" + this.name + "', positionFrames=" + Arrays.toString(this.positionFrames) + ", rotationFrames=" + Arrays.toString(this.rotationFrames) + ", scaleFrames=" + Arrays.toString(this.scaleFrames) + "}";
        }
    }

    public static class SoundEffect {
        private final float time;
        private final String effect;
        private final MolangExpression pitch;
        private final MolangExpression volume;
        private final boolean loop;

        public SoundEffect(float time, String effect, MolangExpression pitch, MolangExpression volume, boolean loop) {
            this.time = time;
            this.effect = effect;
            this.pitch = pitch;
            this.volume = volume;
            this.loop = loop;
        }

        public float getTime() {
            return this.time;
        }

        public String getEffect() {
            return this.effect;
        }

        public MolangExpression getPitch() {
            return this.pitch;
        }

        public MolangExpression getVolume() {
            return this.volume;
        }

        public boolean isLoop() {
            return this.loop;
        }

        public String toString() {
            return "SoundEffect{time=" + this.time + ", effect='" + this.effect + "', pitch='" + this.pitch + "', volume='" + this.volume + "', loop='" + this.loop + "'}";
        }
    }

    public static class ParticleEffect {
        private final float time;
        private final String effect;
        private final String locator;

        public ParticleEffect(float time, String effect, String locator) {
            this.time = time;
            this.effect = effect;
            this.locator = locator;
        }

        public float getTime() {
            return this.time;
        }

        public String getEffect() {
            return this.effect;
        }

        public String getLocator() {
            return this.locator;
        }

        public String toString() {
            return "ParticleEffect{time=" + this.time + ", effect='" + this.effect + "', locator='" + this.locator + "'}";
        }
    }

    public static class TimelineEffect {
        private final float time;
        private final String data;

        public TimelineEffect(float time, String data) {
            this.time = time;
            this.data = data;
        }

        public float getTime() {
            return this.time;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return "TimelineEffect{time=" + this.time + ", data='" + this.data + "'}";
        }
    }

    public static class Deserializer
    implements JsonDeserializer<AnimationData[]> {
        private static Loop parseLoop(JsonElement json) {
            if (!json.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected Boolean or String, was " + class_3518.method_15266((JsonElement)json));
            }
            if (json.getAsJsonPrimitive().isBoolean()) {
                return json.getAsBoolean() ? Loop.LOOP : Loop.NONE;
            }
            if (json.getAsJsonPrimitive().isString()) {
                for (Loop loop : Loop.values()) {
                    if (!loop.name().equalsIgnoreCase(json.getAsString())) continue;
                    return loop;
                }
                throw new JsonSyntaxException("Unsupported loop: " + json.getAsString());
            }
            throw new JsonSyntaxException("Expected Boolean or String, was " + class_3518.method_15266((JsonElement)json));
        }

        private static void parseEffect(BiConsumer<Float, JsonElement> effectConsumer, JsonObject json, String name) {
            if (!json.has(name)) {
                return;
            }
            for (Map.Entry entry : json.getAsJsonObject(name).entrySet()) {
                try {
                    effectConsumer.accept(Float.valueOf(Float.parseFloat((String)entry.getKey())), (JsonElement)entry.getValue());
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException("Failed to parse " + name + " at time '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
        }

        private static void parseTransform(Collection<KeyFrame> frames, JsonObject json, String name, Supplier<MolangExpression[]> defaultValue) throws JsonParseException {
            if (!json.has(name)) {
                return;
            }
            JsonElement transformJson = json.get(name);
            if (transformJson.isJsonObject()) {
                for (Map.Entry entry : transformJson.getAsJsonObject().entrySet()) {
                    try {
                        float time = Float.parseFloat((String)entry.getKey());
                        if (frames.stream().anyMatch(keyFrame -> keyFrame.getTime() == time)) {
                            throw new JsonSyntaxException("Duplicate channel time '" + time + "'");
                        }
                        ChannelData data = Deserializer.parseChannel(transformJson.getAsJsonObject(), (String)entry.getKey(), defaultValue);
                        frames.add(new KeyFrame(time, data.lerpMode, data.pre[0], data.pre[1], data.pre[2], data.post[0], data.post[1], data.post[2]));
                    }
                    catch (NumberFormatException e) {
                        throw new JsonParseException("Invalid keyframe time '" + (String)entry.getKey() + "'", (Throwable)e);
                    }
                }
            } else {
                MolangExpression[] values = JSONTupleParser.getExpression(json, name, 3, defaultValue);
                frames.add(new KeyFrame(0.0f, LerpMode.LINEAR, values[0], values[1], values[2], values[0], values[1], values[2]));
            }
        }

        private static ChannelData parseChannel(JsonObject json, String name, Supplier<MolangExpression[]> defaultValue) throws JsonSyntaxException {
            if (!(json.has(name) || json.get(name).isJsonObject() || json.get(name).isJsonArray())) {
                throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonObject or JsonArray");
            }
            JsonElement transformationElement = json.get(name);
            if (transformationElement.isJsonObject()) {
                JsonObject transformationObject = transformationElement.getAsJsonObject();
                LerpMode lerpMode = LerpMode.LINEAR;
                if (transformationObject.has("lerp_mode")) {
                    lerpMode = null;
                    String mode = class_3518.method_15265((JsonObject)transformationObject, (String)"lerp_mode");
                    for (LerpMode m : LerpMode.values()) {
                        if (!m.name().toLowerCase(Locale.ROOT).equals(mode)) continue;
                        lerpMode = m;
                        break;
                    }
                    if (lerpMode == null) {
                        throw new JsonSyntaxException("Unknown Lerp Mode: " + mode);
                    }
                }
                MolangExpression[] post = JSONTupleParser.getExpression(transformationObject, "post", 3, null);
                return new ChannelData(JSONTupleParser.getExpression(transformationObject, "pre", 3, () -> post), post, lerpMode);
            }
            MolangExpression[] transformation = JSONTupleParser.getExpression(json, name, 3, defaultValue);
            return new ChannelData(transformation, transformation, LerpMode.LINEAR);
        }

        public AnimationData[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashSet<AnimationData> animations = new HashSet<AnimationData>();
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry animationEntry : jsonObject.entrySet()) {
                JsonObject animationObject = ((JsonElement)animationEntry.getValue()).getAsJsonObject();
                String animationName = (String)animationEntry.getKey();
                Loop loop = animationObject.has("loop") ? Deserializer.parseLoop(animationObject.get("loop")) : Loop.NONE;
                MolangExpression blendWeight = JSONTupleParser.getExpression(animationObject, "blend_weight", () -> MolangExpression.of(1.0f));
                float animationLength = class_3518.method_15277((JsonObject)animationObject, (String)"animation_length", (float)-1.0f);
                boolean overridePreviousAnimation = class_3518.method_15258((JsonObject)animationObject, (String)"override_previous_animation", (boolean)false);
                HashSet<BoneAnimation> bones = new HashSet<BoneAnimation>();
                ArrayList soundEffects = new ArrayList();
                ArrayList particleEffects = new ArrayList();
                ArrayList timlineEffects = new ArrayList();
                ArrayList<KeyFrame> positions = new ArrayList<KeyFrame>();
                ArrayList<KeyFrame> rotations = new ArrayList<KeyFrame>();
                ArrayList<KeyFrame> scales = new ArrayList<KeyFrame>();
                for (Map.Entry boneAnimationEntry : class_3518.method_15296((JsonObject)animationObject, (String)"bones").entrySet()) {
                    JsonObject boneAnimationObject = ((JsonElement)boneAnimationEntry.getValue()).getAsJsonObject();
                    Deserializer.parseTransform(positions, boneAnimationObject, "position", () -> new MolangExpression[]{MolangExpression.ZERO, MolangExpression.ZERO, MolangExpression.ZERO});
                    Deserializer.parseTransform(rotations, boneAnimationObject, "rotation", () -> new MolangExpression[]{MolangExpression.ZERO, MolangExpression.ZERO, MolangExpression.ZERO});
                    Deserializer.parseTransform(scales, boneAnimationObject, "scale", () -> new MolangExpression[]{MolangExpression.of(1.0f), MolangExpression.of(1.0f), MolangExpression.of(1.0f)});
                    positions.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    rotations.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    scales.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                    bones.add(new BoneAnimation((String)boneAnimationEntry.getKey(), positions.toArray(new KeyFrame[0]), rotations.toArray(new KeyFrame[0]), scales.toArray(new KeyFrame[0])));
                    positions.clear();
                    rotations.clear();
                    scales.clear();
                }
                Deserializer.parseEffect((time, effectJson) -> {
                    JsonObject soundEffectsJson = class_3518.method_15295((JsonElement)effectJson, (String)"sound_effects");
                    soundEffects.add(new SoundEffect(time.floatValue(), class_3518.method_15265((JsonObject)soundEffectsJson, (String)"effect"), JSONTupleParser.getExpression(soundEffectsJson, "pitch", () -> MolangExpression.of(1.0f)), JSONTupleParser.getExpression(soundEffectsJson, "volume", () -> MolangExpression.of(1.0f)), class_3518.method_15258((JsonObject)soundEffectsJson, (String)"loop", (boolean)false)));
                }, animationObject, "sound_effects");
                Deserializer.parseEffect((time, effectJson) -> {
                    JsonObject particleEffectsJson = class_3518.method_15295((JsonElement)effectJson, (String)"particle_effects");
                    particleEffects.add(new ParticleEffect(time.floatValue(), class_3518.method_15265((JsonObject)particleEffectsJson, (String)"effect"), class_3518.method_15265((JsonObject)particleEffectsJson, (String)"locator")));
                }, animationObject, "particle_effects");
                Deserializer.parseEffect((time, effectJson) -> timlineEffects.add(new TimelineEffect(time.floatValue(), class_3518.method_15287((JsonElement)effectJson, (String)Float.toString(time.floatValue())))), animationObject, "timeline");
                soundEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                particleEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                timlineEffects.sort((a, b) -> Float.compare(a.getTime(), b.getTime()));
                animations.add(new AnimationData(animationName, loop, blendWeight, animationLength, overridePreviousAnimation, bones.toArray(new BoneAnimation[0]), soundEffects.toArray(new SoundEffect[0]), particleEffects.toArray(new ParticleEffect[0]), timlineEffects.toArray(new TimelineEffect[0])));
            }
            return animations.toArray(new AnimationData[0]);
        }

        private static class ChannelData {
            private final MolangExpression[] pre;
            private final MolangExpression[] post;
            private final LerpMode lerpMode;

            private ChannelData(MolangExpression[] pre, MolangExpression[] post, LerpMode lerpMode) {
                this.pre = pre;
                this.post = post;
                this.lerpMode = lerpMode;
            }
        }
    }

    public static class KeyFrame {
        private final float time;
        private final LerpMode lerpMode;
        private final MolangExpression transformPreX;
        private final MolangExpression transformPreY;
        private final MolangExpression transformPreZ;
        private final MolangExpression transformPostX;
        private final MolangExpression transformPostY;
        private final MolangExpression transformPostZ;

        public KeyFrame(float time, LerpMode lerpMode, MolangExpression transformPreX, MolangExpression transformPreY, MolangExpression transformPreZ, MolangExpression transformPostX, MolangExpression transformPostY, MolangExpression transformPostZ) {
            this.time = time;
            this.lerpMode = lerpMode;
            this.transformPreX = transformPreX;
            this.transformPreY = transformPreY;
            this.transformPreZ = transformPreZ;
            this.transformPostX = transformPostX;
            this.transformPostY = transformPostY;
            this.transformPostZ = transformPostZ;
        }

        public float getTime() {
            return this.time;
        }

        public LerpMode getLerpMode() {
            return this.lerpMode;
        }

        public MolangExpression getTransformPreX() {
            return this.transformPreX;
        }

        public MolangExpression getTransformPreY() {
            return this.transformPreY;
        }

        public MolangExpression getTransformPreZ() {
            return this.transformPreZ;
        }

        public MolangExpression getTransformPostX() {
            return this.transformPostX;
        }

        public MolangExpression getTransformPostY() {
            return this.transformPostY;
        }

        public MolangExpression getTransformPostZ() {
            return this.transformPostZ;
        }

        public String toString() {
            return "KeyFrame{time=" + this.time + ", transformPre=(" + this.transformPreX + ", " + this.transformPreY + ", " + this.transformPreZ + "), transformPost=" + this.transformPostX + "," + this.transformPostY + ", " + this.transformPostZ + ")}";
        }
    }

    public static enum LerpMode {
        LINEAR,
        CATMULLROM;

    }
}

