/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.animation;

import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.play.ClientboundSyncAnimationPacket;
import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectHandler;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectSource;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationState;
import gg.moonflower.pollen.pinwheel.core.client.animation.AnimationEffectSound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public interface AnimatedEntity
extends AnimationEffectSource {
    public static <T extends class_1297> void setAnimation(T entity, AnimationState animationState) {
        class_1937 level = entity.field_6002;
        if (level.method_8608()) {
            return;
        }
        AnimationState before = ((AnimatedEntity)entity).getAnimationState();
        ((AnimatedEntity)entity).setAnimationState(animationState);
        if (before != animationState) {
            PollenMessages.PLAY.sendToTracking(entity, new ClientboundSyncAnimationPacket(entity));
        }
    }

    default public void animationTick() {
        if (this.isNoAnimationPlaying()) {
            return;
        }
        AnimationState animationState = this.getAnimationState();
        int animationTick = this.getAnimationTick();
        if (animationTick == 0) {
            this.onAnimationStart(animationState);
        }
        this.setAnimationTick(animationTick + 1);
        if (animationTick >= animationState.getTickDuration() - 1) {
            this.onAnimationStop(animationState);
            this.resetAnimationState();
        }
    }

    default public void onAnimationStart(AnimationState state) {
        AnimationEffectHandler effectHandler = this.getAnimationEffects();
        if (effectHandler != null) {
            effectHandler.reset();
        }
    }

    default public void onAnimationStop(AnimationState state) {
    }

    default public void resetAnimationState() {
        this.setAnimationState(AnimationState.EMPTY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    default public void handleSoundEffect(AnimationData animation, AnimationData.SoundEffect soundEffect) {
        if (!(this instanceof class_1297)) {
            return;
        }
        class_1297 entity = (class_1297)this;
        class_2960 sound = class_2960.method_12829((String)soundEffect.getEffect());
        if (sound != null) {
            MolangRuntime runtime = MolangRuntime.runtime().create(1.0f);
            class_310.method_1551().method_1483().method_4873((class_1113)new AnimationEffectSound(sound, entity.method_5634(), animation, entity, soundEffect.getPitch().safeResolve(runtime), soundEffect.getVolume().safeResolve(runtime), soundEffect.isLoop()));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    default public void handleParticleEffect(AnimationData animation, AnimationData.ParticleEffect particleEffect, double xOffset, double yOffset, double zOffset) {
        if (!(this instanceof class_1297)) {
            return;
        }
        class_1297 entity = (class_1297)this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    default public void handleTimelineEffect(AnimationData animation, AnimationData.TimelineEffect timelineEffect) {
    }

    public int getAnimationTick();

    default public float getRenderAnimationTick(float partialTicks) {
        return (float)this.getAnimationTick() + partialTicks;
    }

    public void setAnimationTick(int var1);

    public AnimationState getAnimationState();

    default public AnimationState getIdleAnimationState() {
        return AnimationState.EMPTY;
    }

    public void setAnimationState(AnimationState var1);

    @Nullable
    public AnimationEffectHandler getAnimationEffects();

    default public boolean isNoAnimationPlaying() {
        return this.getAnimationState() == AnimationState.EMPTY;
    }

    default public boolean isAnimationPlaying(AnimationState state) {
        return this.getAnimationState() == state;
    }

    public AnimationState[] getAnimationStates();
}

