/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.texture;

import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.client.texture.TextureTableLoader;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import gg.moonflower.pollen.pinwheel.core.client.texture.GeometryTextureSpriteUploader;
import gg.moonflower.pollen.pinwheel.core.client.texture.LocalTextureTableLoader;
import gg.moonflower.pollen.pinwheel.core.client.texture.StaticTextureTableLoader;
import gg.moonflower.pollen.pinwheel.core.client.util.DynamicReloader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class GeometryTextureManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Reloader RELOADER = new Reloader();
    private static final DynamicReloader DYNAMIC_RELOADER = new DynamicReloader();
    private static final Set<TextureTableLoader> PROVIDERS = new HashSet<TextureTableLoader>();
    private static final Map<class_2960, GeometryModelTextureTable> TEXTURES = new HashMap<class_2960, GeometryModelTextureTable>();
    private static GeometryTextureSpriteUploader spriteUploader;

    private GeometryTextureManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(class_3264.field_14188, RELOADER);
        GeometryTextureManager.addProvider(new LocalTextureTableLoader());
    }

    public static void addTexture(class_2960 location, GeometryModelTextureTable texture, @Nullable String hashTable) {
        GeometryTextureManager.addProvider(new StaticTextureTableLoader(location, texture, hashTable));
    }

    public static void addProvider(TextureTableLoader provider) {
        PROVIDERS.add(provider);
    }

    public static GeometryModelTextureTable getTextures(class_2960 location) {
        return TEXTURES.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown texture table with key '{}'", (Object)location);
            return GeometryModelTextureTable.EMPTY;
        });
    }

    public static CompletableFuture<class_3902> reload(boolean showLoadingScreen) {
        return DYNAMIC_RELOADER.reload(showLoadingScreen);
    }

    public static GeometryAtlasTexture getAtlas() {
        return spriteUploader;
    }

    public static Collection<GeometryModelTextureTable> getAllTextures() {
        return TEXTURES.values();
    }

    public static boolean isReloading() {
        return DYNAMIC_RELOADER.isReloading();
    }

    static {
        DYNAMIC_RELOADER.addListener(RELOADER);
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])PROVIDERS.stream().map(provider -> provider.method_25931(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor)).toArray(CompletableFuture[]::new)).thenApplyAsync(a -> {
                HashMap textures = new HashMap();
                HashSet hashTables = new HashSet();
                PROVIDERS.forEach(provider -> {
                    try {
                        provider.addTextures((location, texture) -> {
                            if (textures.put(location, texture) != null) {
                                LOGGER.warn("Texture at location '" + location + "' already exists and is being overridden.");
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("Provider " + provider + " failed to gather textures", (Throwable)e);
                    }
                });
                PROVIDERS.forEach(provider -> provider.addHashTables(hashTables::add));
                return Pair.of(textures, (Object)hashTables.toArray(new String[0]));
            }, backgroundExecutor)).thenComposeAsync(pair -> {
                if (spriteUploader == null) {
                    spriteUploader = new GeometryTextureSpriteUploader(class_310.method_1551().method_1531());
                }
                return spriteUploader.setTextures((Map)pair.getLeft(), (String[])pair.getRight()).method_25931(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }, gameExecutor)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(textures -> {
                TEXTURES.clear();
                PROVIDERS.forEach(provider -> provider.addTextures((location, texture) -> {
                    if (TEXTURES.put((class_2960)location, (GeometryModelTextureTable)texture) != null) {
                        LOGGER.warn("Texture at location '" + location + "' already exists and is being overridden.");
                    }
                }));
            }, gameExecutor);
        }

        @Override
        public class_2960 getPollenId() {
            return new class_2960("pollen", "geometry_texture_manager");
        }
    }
}

