/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.render;

import gg.moonflower.pollen.api.event.events.client.resource.ClientTagUpdateEvent;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.RenderExclusively;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class BlockRendererRegistry {
    private static final RenderSet EMPTY = new RenderSet();
    private static final Map<class_2248, RenderSet> RENDERERS = new HashMap<class_2248, RenderSet>();
    private static final Map<class_3494<class_2248>, RenderSet> TAG_RENDERERS = new HashMap<class_3494<class_2248>, RenderSet>();
    private static final Lock RENDERERS_LOCK = new ReentrantLock();
    private static final Lock TAG_RENDERERS_LOCK = new ReentrantLock();
    private static final Map<class_2248, RenderSet> RENDERERS_CACHE = new ConcurrentHashMap<class_2248, RenderSet>();

    private static void addToSet(RenderSet renderers, BlockRenderer renderer) {
        RenderExclusively annotation = renderer.getClass().getDeclaredAnnotation(RenderExclusively.class);
        if (annotation != null && annotation.override()) {
            renderers.updateOverride(renderer, annotation);
        } else {
            renderers.addChild(renderer);
        }
    }

    public static void register(class_2248 block, BlockRenderer renderer) {
        RENDERERS_LOCK.lock();
        RenderSet renderers = RENDERERS.computeIfAbsent(block, __ -> new RenderSet());
        RENDERERS_LOCK.unlock();
        BlockRendererRegistry.addToSet(renderers, renderer);
    }

    public static void register(class_3494<class_2248> tag, BlockRenderer renderer) {
        TAG_RENDERERS_LOCK.lock();
        RenderSet renderers = TAG_RENDERERS.computeIfAbsent(tag, __ -> new RenderSet());
        TAG_RENDERERS_LOCK.unlock();
        BlockRendererRegistry.addToSet(renderers, renderer);
    }

    public static List<BlockRenderer> get(class_2248 block) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            RENDERERS_LOCK.lock();
            try {
                List<BlockRenderer> list = RENDERERS.getOrDefault(block, EMPTY).values();
                return list;
            }
            finally {
                RENDERERS_LOCK.unlock();
            }
        }
        class_5414 tags = connection.method_2867().method_33164(class_2378.field_25105);
        if (RENDERERS_CACHE.containsKey(block)) {
            return RENDERERS_CACHE.get(block).values();
        }
        RenderSet set = null;
        RENDERERS_LOCK.lock();
        if (RENDERERS.containsKey(block)) {
            set = new RenderSet();
            RENDERERS.get(block).values().forEach(set::addChild);
        }
        RENDERERS_LOCK.unlock();
        TAG_RENDERERS_LOCK.lock();
        for (class_2960 tagId : tags.method_30206((Object)block)) {
            class_3494 tag = tags.method_30213(tagId);
            if (!TAG_RENDERERS.containsKey(tag)) continue;
            if (set == null) {
                set = new RenderSet();
            }
            TAG_RENDERERS.get(tag).values().forEach(set::addChild);
        }
        TAG_RENDERERS_LOCK.unlock();
        if (set == null) {
            set = EMPTY;
        }
        RENDERERS_CACHE.put(block, set);
        return set.values();
    }

    @Nullable
    public static BlockRenderer getFirst(class_2248 block) {
        List<BlockRenderer> renderers = BlockRendererRegistry.get(block);
        return !renderers.isEmpty() ? renderers.get(0) : null;
    }

    static {
        ClientTagUpdateEvent.EVENT.register(RENDERERS_CACHE::clear);
    }

    private static class RenderSet {
        private volatile BlockRenderer override = null;
        private final Set<BlockRenderer> children = ConcurrentHashMap.newKeySet();
        private volatile List<BlockRenderer> cache = Collections.emptyList();

        private RenderSet() {
        }

        private synchronized void updateOverride(BlockRenderer renderer, RenderExclusively annotation) {
            if (this.override == null || annotation.priority() < RenderSet.getPriority(this.override)) {
                this.override = renderer;
                this.cache = null;
            }
        }

        private void addChild(BlockRenderer renderer) {
            this.children.add(renderer);
            this.cache = null;
        }

        private List<BlockRenderer> values() {
            if (this.cache == null) {
                this.cache = new ArrayList<BlockRenderer>(this.children);
                this.cache.sort(Comparator.comparingInt(RenderSet::getPriority));
                if (this.override != null) {
                    this.cache.add(0, this.override);
                }
            }
            return this.cache;
        }

        private static int getPriority(BlockRenderer renderer) {
            RenderExclusively annotation = renderer.getClass().getDeclaredAnnotation(RenderExclusively.class);
            return annotation != null ? annotation.priority() : 1000;
        }
    }
}

