/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.VanillaModelMapping;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public final class GeometryModelRenderer {
    private static final Map<class_3879, Map<String, class_630>> MODEL_PARTS = new HashMap<class_3879, Map<String, class_630>>();
    private static final Map<String, String> MAPPED_NAMES = new HashMap<String, String>();

    private GeometryModelRenderer() {
    }

    public static void copyModelAngles(@Nullable class_3879 parent, GeometryModel model) {
        if (parent == null) {
            model.resetTransformation();
            return;
        }
        Map parentParts = MODEL_PARTS.computeIfAbsent(parent, GeometryModelRenderer::mapRenderers);
        for (String modelKey : model.getParentModelKeys()) {
            String name = MAPPED_NAMES.computeIfAbsent(modelKey, key -> VanillaModelMapping.get(parent.getClass(), key));
            if (!parentParts.containsKey(name)) continue;
            model.copyAngles("parent." + modelKey, (class_630)parentParts.get(name));
        }
    }

    public static void render(GeometryModel model, @Nullable class_2960 textureLocation, class_4597 buffer, class_4587 matrixStack, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        GeometryModelRenderer.render(model, textureLocation, buffer, matrixStack, packedLight, packedOverlay, red, green, blue, alpha, null);
    }

    public static void render(GeometryModel model, @Nullable class_2960 textureLocation, class_4597 buffer, class_4587 matrixStack, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, @Nullable Consumer<class_1921.class_4688.class_4689> renderTypeConsumer) {
        if (GeometryTextureManager.isReloading()) {
            return;
        }
        GeometryModelTextureTable textures = textureLocation == null ? GeometryModelTextureTable.EMPTY : GeometryTextureManager.getTextures(textureLocation);
        for (String material : model.getMaterialKeys()) {
            GeometryModelTexture[] layers;
            for (GeometryModelTexture texture : layers = textures.getLayerTextures(material)) {
                model.render(material, texture, matrixStack, model.getBuffer(buffer, GeometryTextureManager.getAtlas(), texture, renderTypeConsumer), texture.isGlowing() ? 0xF000F0 : packedLight, packedOverlay, red * texture.getRed(), green * texture.getGreen(), blue * texture.getBlue(), alpha);
            }
        }
    }

    private static Map<String, class_630> mapRenderers(class_3879 model) {
        HashMap<String, class_630> renderers = new HashMap<String, class_630>();
        for (Class<?> i = model.getClass(); i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic() || !class_630.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    renderers.put(field.getName(), (class_630)field.get(model));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return renderers;
    }
}

