/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.common.collect.Iterables;
import gg.moonflower.pollen.core.mixin.client.AgeableListModelAccessor;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import gg.moonflower.pollen.pinwheel.core.client.geometry.JavaModelConverter;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public interface GeometryModel {
    public static final GeometryModel EMPTY = new GeometryModel(){

        @Override
        public void render(String material, GeometryModelTexture texture, class_4587 matrixStack, class_4588 builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        }

        @Override
        public void resetTransformation() {
        }

        @Override
        public void copyAngles(@Nullable String parent, class_630 modelPart) {
        }

        @Override
        public Optional<class_630> getModelPart(String part) {
            return Optional.empty();
        }

        @Override
        public class_630[] getChildRenderers(String part) {
            return new class_630[0];
        }

        @Override
        public class_630[] getModelParts() {
            return new class_630[0];
        }

        @Override
        public String[] getParentModelKeys() {
            return new String[0];
        }

        @Override
        public String[] getMaterialKeys() {
            return new String[0];
        }

        @Override
        public float getTextureWidth() {
            return 16.0f;
        }

        @Override
        public float getTextureHeight() {
            return 16.0f;
        }
    };

    public static GeometryModel create(GeometryModelData data) {
        return new BedrockGeometryModel(data.getDescription().getTextureWidth(), data.getDescription().getTextureHeight(), data.getBones());
    }

    public static GeometryModel create(int textureWidth, int textureHeight, GeometryModelData.Bone ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, bones);
    }

    public static GeometryModel create(int textureWidth, int textureHeight, class_630 ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert(bones));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, class_4595<?> model) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((class_630[])Iterables.toArray((Iterable)model.method_22960(), class_630.class)));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, class_4592<?> model) {
        AgeableListModelAccessor accessor = (AgeableListModelAccessor)model;
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((class_630[])Iterables.toArray((Iterable)Iterables.concat(accessor.invokeHeadParts(), accessor.invokeBodyParts()), class_630.class)));
    }

    public void render(String var1, GeometryModelTexture var2, class_4587 var3, class_4588 var4, int var5, int var6, float var7, float var8, float var9, float var10);

    public void resetTransformation();

    public void copyAngles(@Nullable String var1, class_630 var2);

    public Optional<class_630> getModelPart(String var1);

    public class_630[] getChildRenderers(String var1);

    public class_630[] getModelParts();

    public String[] getParentModelKeys();

    public String[] getMaterialKeys();

    public float getTextureWidth();

    public float getTextureHeight();

    default public class_4588 getBuffer(class_4597 buffer, GeometryAtlasTexture atlas, GeometryModelTexture texture, @Nullable Consumer<class_1921.class_4688.class_4689> renderTypeConsumer) {
        return atlas.getSprite(texture.getLocation()).method_24108(buffer.getBuffer(texture.getLayer().getRenderType(texture, atlas, renderTypeConsumer)));
    }
}

