/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.pollen.pinwheel.api.client.framebuffer.AdvancedFboAttachment;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL30;

public class AdvancedFboRenderAttachment
implements AdvancedFboAttachment {
    public static final int MAX_SAMPLES = GL30.glGetInteger((int)36183);
    private int id = -1;
    private final int attachmentType;
    private final int attachmentFormat;
    private final int width;
    private final int height;
    private final int samples;

    public AdvancedFboRenderAttachment(int attachmentType, int attachmentFormat, int width, int height, int samples) {
        this.attachmentType = attachmentType;
        this.attachmentFormat = attachmentFormat;
        this.width = width;
        this.height = height;
        Validate.inclusiveBetween((long)1L, (long)MAX_SAMPLES, (long)samples);
        this.samples = samples;
    }

    private void createRaw() {
        this.bindAttachment();
        if (this.samples == 1) {
            GL30.glRenderbufferStorage((int)36161, (int)this.attachmentFormat, (int)this.width, (int)this.height);
        } else {
            GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)this.attachmentFormat, (int)this.width, (int)this.height);
        }
        this.unbindAttachment();
    }

    private int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == -1) {
            this.id = GL30.glGenRenderbuffers();
        }
        return this.id;
    }

    @Override
    public void create() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::createRaw);
        } else {
            this.createRaw();
        }
    }

    @Override
    public void attach(int target, int attachment) {
        Validate.isTrue((this.attachmentType != 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glFramebufferRenderbuffer((int)target, (int)this.attachmentType, (int)36161, (int)this.getId()));
        } else {
            GL30.glFramebufferRenderbuffer((int)target, (int)this.attachmentType, (int)36161, (int)this.getId());
        }
    }

    @Override
    public void bindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)this.getId()));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)this.getId());
        }
    }

    @Override
    public void unbindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)0));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)0);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getSamples() {
        return this.samples;
    }

    @Override
    public boolean canSample() {
        return false;
    }

    @Override
    public AdvancedFboAttachment createCopy() {
        return new AdvancedFboRenderAttachment(this.attachmentType, this.attachmentFormat, this.width, this.height, this.samples);
    }

    public void free() {
        if (this.id == -1) {
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                GL30.glDeleteRenderbuffers((int)this.id);
                this.id = -1;
            });
        } else {
            GL30.glDeleteRenderbuffers((int)this.id);
            this.id = -1;
        }
    }
}

