/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import gg.moonflower.pollen.pinwheel.core.client.animation.LocalAnimationLoader;
import gg.moonflower.pollen.pinwheel.core.client.util.DynamicReloader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public final class AnimationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Reloader RELOADER = new Reloader();
    private static final DynamicReloader DYNAMIC_RELOADER = new DynamicReloader();
    private static final Set<BackgroundLoader<Map<class_2960, AnimationData>>> LOADERS = new HashSet<BackgroundLoader<Map<class_2960, AnimationData>>>();
    private static final Map<class_2960, AnimationData> ANIMATIONS = new HashMap<class_2960, AnimationData>();

    private AnimationManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(class_3264.field_14188, RELOADER);
        AnimationManager.addLoader(new LocalAnimationLoader());
    }

    public static void addLoader(BackgroundLoader<Map<class_2960, AnimationData>> loader) {
        LOADERS.add(loader);
    }

    public static CompletableFuture<class_3902> reload(boolean showLoadingScreen) {
        return DYNAMIC_RELOADER.reload(showLoadingScreen);
    }

    public static AnimationData getAnimation(class_2960 location) {
        return ANIMATIONS.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown animation with key '{}'", (Object)location);
            return AnimationData.EMPTY;
        });
    }

    public static boolean isReloading() {
        return DYNAMIC_RELOADER.isReloading();
    }

    static {
        DYNAMIC_RELOADER.addListener(RELOADER);
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap animationData = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(animationLoader -> animationLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(pairs -> {
                for (Map.Entry entry : pairs.entrySet()) {
                    if (animationData.put((class_2960)entry.getKey(), (AnimationData)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate animation: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + animationData.size() + " animations.");
                ANIMATIONS.clear();
                ANIMATIONS.putAll(animationData);
            }, gameExecutor);
        }

        @Override
        public class_2960 getPollenId() {
            return new class_2960("pollen", "animation_manager");
        }
    }
}

