/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModel;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelRenderer;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_583;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class AnimatedGeometryEntityModel<T extends class_1297>
extends class_583<T> {
    private final class_2960 model;
    private class_2960 texture;
    private class_2960[] animations;
    private MolangVariableProvider variableProvider;

    public AnimatedGeometryEntityModel(class_2960 model) {
        this.model = model;
        this.texture = null;
        this.animations = new class_2960[0];
        this.variableProvider = null;
    }

    private MolangRuntime.Builder createRuntime(T entity, float limbSwing, float limbSwingAmount, float yaw, float pitch) {
        float partialTicks = class_310.method_1551().method_1488();
        MolangRuntime.Builder builder = MolangRuntime.runtime();
        if (((class_1297)entity).field_6002 instanceof class_638) {
            builder.setQuery("actor_count", () -> Float.valueOf(((class_638)entity.field_6002).method_18120()));
        }
        builder.setQuery("time_of_day", () -> Float.valueOf(entity.field_6002.method_30274(partialTicks) / 24000.0f));
        builder.setQuery("day", () -> Float.valueOf(entity.field_6002.method_8532() / 24000L + 1L));
        builder.setQuery("moon_phase", () -> Float.valueOf(entity.field_6002.method_30273()));
        builder.setQuery("moon_brightness", () -> Float.valueOf(entity.field_6002.method_30272()));
        builder.setQuery("is_on_ground", entity.method_24828() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water", entity.method_5799() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water_or_rain", entity.method_5721() ? 1.0f : 0.0f);
        builder.setQuery("is_in_contact_with_water", entity.method_5637() ? 1.0f : 0.0f);
        builder.setQuery("is_moving", () -> Float.valueOf(entity.method_18798().method_1027() > 1.0E-7 ? 1.0f : 0.0f));
        builder.setQuery("is_alive", entity.method_5805() ? 1.0f : 0.0f);
        builder.setQuery("is_fire_immune", entity.method_5753() ? 1.0f : 0.0f);
        builder.setQuery("is_on_fire", entity.method_5809() ? 1.0f : 0.0f);
        builder.setQuery("is_first_person", entity == class_310.method_1551().method_1560() && class_310.method_1551().field_1690.method_31044() == class_5498.field_26664 ? 1.0f : 0.0f);
        builder.setQuery("is_invisible", entity.method_5767() ? 1.0f : 0.0f);
        builder.setQuery("is_ghost", entity.method_7325() ? 1.0f : 0.0f);
        builder.setQuery("ground_speed", () -> {
            class_243 velocity = entity.method_18798();
            return Float.valueOf(class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350))));
        });
        if (entity instanceof class_1309) {
            builder.setQuery("modified_move_speed", ((class_1309)entity).method_6029());
        }
        builder.setQuery("modified_distance_moved", ((class_1297)entity).field_5994);
        builder.setQuery("vertical_speed", (float)entity.method_18798().method_10214());
        builder.setQuery("head_x_rotation", pitch);
        builder.setQuery("head_y_rotation", yaw);
        if (entity instanceof class_1309) {
            builder.setQuery("body_y_rotation", () -> Float.valueOf(class_3532.method_16439((float)partialTicks, (float)((class_1309)entity).field_6220, (float)((class_1309)entity).field_6283)));
        }
        builder.setQuery("head_x_rotation_speed", () -> Float.valueOf(entity.method_5695(partialTicks) - entity.method_5695((float)((double)partialTicks - 0.1))));
        builder.setQuery("head_y_rotation_speed", () -> Float.valueOf(entity.method_5705(partialTicks) - entity.method_5705((float)((double)partialTicks - 0.1))));
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            builder.setQuery("health", livingEntity.method_6032());
            builder.setQuery("max_health", livingEntity.method_6063());
            builder.setQuery("is_baby", livingEntity.method_6109() ? 1.0f : 0.0f);
        }
        builder.setQuery("distance_from_camera", () -> Float.valueOf((float)class_310.method_1551().field_1773.method_19418().method_19326().method_1022(entity.method_19538())));
        builder.setQuery("camera_distance_range_lerp", 2, context -> {
            float second;
            float first = context.resolve(0);
            if (first == (second = context.resolve(1))) {
                return 1.0f;
            }
            float smaller = Math.min(first, second);
            float larger = Math.max(first, second);
            double distance = class_310.method_1551().field_1773.method_19418().method_19326().method_1022(entity.method_19538());
            if (distance <= (double)smaller) {
                return smaller;
            }
            if (distance >= (double)larger) {
                return larger;
            }
            return (float)((distance - (double)smaller) / (double)(larger - smaller));
        });
        builder.setQuery("lod_index", -1, context -> {
            if (context.getParameters() <= 0) {
                return 0.0f;
            }
            double distance = class_310.method_1551().field_1773.method_19418().method_19326().method_1022(entity.method_19538());
            for (int i = 0; i < context.getParameters(); ++i) {
                if (!(distance < (double)context.resolve(0))) continue;
                return i;
            }
            return context.getParameters() - 1;
        });
        builder.setQuery("position", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.method_23316((double)partialTicks) : (index == 1 ? entity.method_23323((double)partialTicks) : entity.method_23324((double)partialTicks)));
        });
        builder.setQuery("position_delta", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.method_18798().method_10216() : (index == 1 ? entity.method_18798().method_10214() : entity.method_18798().method_10215()));
        });
        builder.setQuery("limb_swing", limbSwing);
        builder.setQuery("limb_swing_amount", limbSwingAmount);
        return builder;
    }

    public void method_2819(T entity, float limbSwing, float limbSwingAmount, float animationTicks, float netHeadYaw, float headPitch) {
        GeometryModel model = this.getModel();
        model.resetTransformation();
        if (model instanceof AnimatedModel && this.animations.length > 0) {
            class_3695 profiler = class_310.method_1551().method_16011();
            profiler.method_15396("createMolangRuntime");
            MolangRuntime.Builder builder = this.createRuntime(entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
            if (entity instanceof MolangVariableProvider) {
                builder.setVariables((MolangVariableProvider)entity);
            }
            if (this.variableProvider != null) {
                builder.setVariables(this.variableProvider);
            }
            profiler.method_15405("applyMolangAnimation");
            ((AnimatedModel)((Object)model)).applyAnimations(animationTicks / 20.0f, builder, this.getAnimations());
            profiler.method_15407();
        }
    }

    public void method_2828(class_4587 matrixStack, class_4588 builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderToBuffer(matrixStack, (class_4597)class_310.method_1551().method_22940().method_23000(), packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderToBuffer(class_4587 matrixStack, class_4597 source, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, (double)1.501f, 0.0);
        GeometryModelRenderer.render(this.getModel(), this.texture, source, matrixStack, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.method_22909();
    }

    public GeometryModel getModel() {
        return GeometryModelManager.getModel(this.model);
    }

    @Nullable
    public class_2960 getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable class_2960 texture) {
        this.texture = texture;
    }

    public class_2960[] getAnimationNames() {
        return this.animations;
    }

    public AnimationData[] getAnimations() {
        return (AnimationData[])Arrays.stream(this.animations).map(AnimationManager::getAnimation).filter(animation -> animation != AnimationData.EMPTY).toArray(AnimationData[]::new);
    }

    public void setAnimations(class_2960 ... animations) {
        this.animations = animations;
    }

    public void setVariableProvider(@Nullable MolangVariableProvider variableProvider) {
        this.variableProvider = variableProvider;
    }
}

