/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client;

import com.google.common.util.concurrent.MoreExecutors;
import gg.moonflower.pollen.pinwheel.core.client.util.HashedTextureCache;
import gg.moonflower.pollen.pinwheel.core.client.util.TimedTextureCache;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_148;
import net.minecraft.class_2966;
import net.minecraft.class_3532;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface FileCache {
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";
    @ApiStatus.Internal
    public static final AtomicInteger ID_GENERATOR = new AtomicInteger();

    public static InputStream get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();
        final CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            client.close();
            response.close();
            throw new IOException("Failed to connect to '" + url + "'. " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
        }
        return new EofSensorInputStream(response.getEntity().getContent(), new EofSensorWatcher(){

            public boolean eofDetected(InputStream wrapped) {
                return true;
            }

            public boolean streamClosed(InputStream wrapped) throws IOException {
                response.close();
                return true;
            }

            public boolean streamAbort(InputStream wrapped) throws IOException {
                response.close();
                return true;
            }
        });
    }

    public static ExecutorService createOnlineWorker() {
        final Logger logger = LogManager.getLogger();
        int i = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)7);
        Object executorservice = i <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(i, pool -> {
            ForkJoinWorkerThread forkjoinworkerthread = new ForkJoinWorkerThread(pool){

                @Override
                protected void onTermination(@Nullable Throwable t) {
                    if (t != null) {
                        logger.warn("{} died", (Object)this.getName(), (Object)t);
                    } else {
                        logger.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(t);
                }
            };
            forkjoinworkerthread.setName("Worker-Pollen Online Fetcher-" + ID_GENERATOR.getAndIncrement());
            return forkjoinworkerthread;
        }, (thread, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof class_148) {
                class_2966.method_12847((String)((class_148)throwable).method_631().method_568());
                System.exit(-1);
            }
            logger.error("Caught exception in thread " + thread, throwable);
        }, true);
        return executorservice;
    }

    public static FileCache direct(Executor executor) {
        return new TimedTextureCache(executor, 0L, TimeUnit.SECONDS);
    }

    public static FileCache hashed(Executor executor, String ... hashTableUrls) {
        return new HashedTextureCache(executor, hashTableUrls);
    }

    public static FileCache timed(Executor executor, long cacheTime, TimeUnit cacheTimeUnit) {
        return new TimedTextureCache(executor, cacheTime, cacheTimeUnit);
    }

    public CompletableFuture<Path> requestResource(String var1, boolean var2);
}

