/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.node;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.core.node.MolangConstantNode;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangSetVariableNode
implements MolangExpression {
    private final String object;
    private final String name;
    private final MolangExpression expression;

    public MolangSetVariableNode(String object, String name, MolangExpression expression) {
        this.object = object;
        this.name = name;
        this.expression = expression;
    }

    @Override
    public float resolve(MolangEnvironment environment) throws MolangException {
        environment.get(this.object).set(this.name, new MolangConstantNode(this.expression.resolve(environment)));
        return this.expression.resolve(environment);
    }

    public String toString() {
        return this.object + "." + this.name + " = " + this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MolangSetVariableNode that = (MolangSetVariableNode)o;
        return this.object.equals(that.object) && this.name.equals(that.name) && this.expression.equals(that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.name, this.expression);
    }
}

