/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.node;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangConditionalNode
implements MolangExpression {
    private final MolangExpression condition;
    private final MolangExpression first;
    private final MolangExpression branch;

    public MolangConditionalNode(MolangExpression condition, MolangExpression first, MolangExpression branch) {
        this.condition = condition;
        this.first = first;
        this.branch = branch;
    }

    @Override
    public float resolve(MolangEnvironment environment) throws MolangException {
        return (this.condition.resolve(environment) != 0.0f ? this.first : this.branch).resolve(environment);
    }

    public String toString() {
        return this.condition + " ? " + this.first + " : " + this.branch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MolangConditionalNode that = (MolangConditionalNode)o;
        return this.condition.equals(that.condition) && this.first.equals(that.first) && this.branch.equals(that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.first, this.branch);
    }
}

