/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.resource.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigBuilder;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.config.PollinatedModConfig;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceCondition;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.util.NumberCompareMode;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigResourceCondition
implements PollinatedResourceCondition {
    public static final class_2960 NAME = new class_2960("pollen", "config");

    @Override
    public boolean test(JsonObject json) throws JsonParseException {
        class_2960 configId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"config"));
        Optional<PollinatedModConfig> optional = ConfigManager.get(configId.method_12836(), ConfigResourceCondition.byName(configId.method_12832()));
        if (!optional.isPresent() || optional.get().getConfigData() == null) {
            return false;
        }
        String configKey = class_3518.method_15265((JsonObject)json, (String)"name");
        if (!json.has("value")) {
            throw new JsonSyntaxException("Expected 'value'");
        }
        Object entry = optional.get().getConfigData().get(configKey);
        if (entry == null) {
            throw new JsonSyntaxException("Unknown config key: " + configKey);
        }
        return ConfigResourceCondition.testEntry(entry instanceof PollinatedConfigBuilder.ConfigValue ? ((PollinatedConfigBuilder.ConfigValue)entry).get() : entry, json, json.get("value"));
    }

    private static boolean testEntry(Object value, JsonObject json, JsonElement jsonValue) {
        if (value instanceof Number) {
            return ConfigResourceCondition.testNumber((Number)value, json, jsonValue);
        }
        return ConfigResourceCondition.testSimple(value, jsonValue);
    }

    private static PollinatedConfigType byName(String name) {
        for (PollinatedConfigType type : PollinatedConfigType.values()) {
            if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return type;
        }
        throw new JsonSyntaxException("Unknown config type: " + name);
    }

    private static boolean testSimple(Object entry, JsonElement value) {
        return String.valueOf(entry).equals(ConfigResourceCondition.toString(value));
    }

    private static String toString(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return "null";
        }
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        throw new JsonSyntaxException("Unsupported generic config type: " + class_3518.method_15266((JsonElement)json));
    }

    private static boolean testNumber(Number entry, JsonObject json, JsonElement value) {
        if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isNumber()) {
            throw new JsonSyntaxException("Expected Number, got " + class_3518.method_15266((JsonElement)value));
        }
        JsonPrimitive primitiveValue = value.getAsJsonPrimitive();
        NumberCompareMode compareMode = json.has("mode") ? NumberCompareMode.byName(class_3518.method_15265((JsonObject)json, (String)"mode")) : NumberCompareMode.EQUAL;
        return compareMode.test(entry, primitiveValue.getAsNumber());
    }

    public static class NumberProvider
    extends SimpleProvider {
        private final NumberCompareMode mode;

        public NumberProvider(String modId, PollinatedConfigType type, String key, Number value, NumberCompareMode mode) {
            super(modId, type, key, value);
            this.mode = mode;
        }

        @Override
        public void write(JsonObject json) {
            super.write(json);
            if (this.mode != NumberCompareMode.EQUAL) {
                json.addProperty("mode", this.mode.getSymbol());
            }
        }
    }

    public static class SimpleProvider
    implements PollinatedResourceConditionProvider {
        private final String modId;
        private final PollinatedConfigType type;
        private final String key;
        private final String value;

        public SimpleProvider(String modId, PollinatedConfigType type, String key, Object value) {
            this.modId = modId;
            this.type = type;
            this.key = key;
            this.value = String.valueOf(value);
        }

        @Override
        public void write(JsonObject json) {
            json.addProperty("config", this.modId + ":" + this.type.name().toLowerCase(Locale.ROOT));
            json.addProperty("name", this.key);
            json.addProperty("value", this.value);
        }

        @Override
        public class_2960 getName() {
            return NAME;
        }
    }
}

