/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.PollenClientPlayPacketHandler;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundUpdateSettingsPacket
implements PollinatedPacket<PollenClientPlayPacketHandler> {
    private final UUID player;
    private final String entitlement;
    private final JsonObject settings;

    public ClientboundUpdateSettingsPacket(class_1657 player, String entitlement, JsonObject settings) {
        this.player = player.method_5667();
        this.entitlement = entitlement;
        this.settings = settings;
    }

    public ClientboundUpdateSettingsPacket(class_2540 buf) throws IOException {
        this.player = buf.method_10790();
        this.entitlement = buf.method_19772();
        try {
            this.settings = new JsonParser().parse(buf.method_19772()).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writePacketData(class_2540 buf) throws IOException {
        buf.method_10797(this.player);
        buf.method_10814(this.entitlement);
        buf.method_10814(this.settings.toString());
    }

    @Override
    public void processPacket(PollenClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleUpdateSettingsPacket(this, ctx);
    }

    public UUID getPlayer() {
        return this.player;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public JsonObject getSettings() {
        return this.settings;
    }
}

