/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network;

import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.network.play.ClientboundSyncAnimationPacket;
import gg.moonflower.pollen.core.network.play.ClientboundUpdateSettingsPacket;
import gg.moonflower.pollen.core.network.play.PollenClientPlayPacketHandler;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimatedEntity;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenClientPlayPacketHandlerImpl
implements PollenClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void handleSyncAnimationPacket(ClientboundSyncAnimationPacket msg, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            class_1297 e = level.method_8469(msg.getEntityId());
            if (!(e instanceof AnimatedEntity)) {
                LOGGER.warn("Server sent animation for entity: " + e + ", but it is not an instance of AnimatedEntity");
                return;
            }
            AnimatedEntity entity = (AnimatedEntity)e;
            int animationId = msg.getAnimationId();
            if (animationId == -1) {
                entity.resetAnimationState();
                return;
            }
            AnimationState[] animations = entity.getAnimationStates();
            if (animationId < 0 || animationId >= animations.length) {
                LOGGER.warn("Server sent invalid animation " + animationId + " for entity: " + e);
                return;
            }
            entity.setAnimationState(animations[animationId]);
        });
    }

    @Override
    public void handleUpdateSettingsPacket(ClientboundUpdateSettingsPacket msg, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            class_1657 player = level.method_18470(msg.getPlayer());
            if (player == null) {
                LOGGER.warn("Server sent settings for unknown player: " + msg.getSettings());
                return;
            }
            EntitlementManager.updateEntitlementSettings(msg.getPlayer(), msg.getEntitlement(), entitlement -> entitlement.updateSettings(msg.getSettings()));
        });
    }
}

