/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.fabric;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PollenFabricMixinPlugin
implements IMixinConfigPlugin {
    private boolean sodiumLoaded;
    private boolean irisLoaded;
    private boolean optifineLoaded;

    public void onLoad(String mixinPackage) {
        FabricLoader loader = FabricLoader.getInstance();
        this.sodiumLoaded = loader.isModLoaded("sodium");
        this.irisLoaded = loader.isModLoaded("iris");
        this.optifineLoaded = loader.isModLoaded("optifabric");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.optifineLoaded && mixinClassName.equals("gg.moonflower.pollen.core.mixin.fabric.client.ShaderInstanceMixin")) {
            return false;
        }
        if (!this.sodiumLoaded && mixinClassName.startsWith("gg.moonflower.pollen.core.mixin.fabric.sodium")) {
            return false;
        }
        if (!this.irisLoaded && mixinClassName.startsWith("gg.moonflower.pollen.core.mixin.fabric.iris")) {
            return false;
        }
        return !this.sodiumLoaded || !"gg.moonflower.pollen.core.mixin.fabric.client.LevelRendererVanillaMixin".equals(mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

