/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.crafting.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.platform.Platform;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1845.class})
public class PotionBrewingMixin {
    @Unique
    private static List<PollenBrewingRecipe> getRecipes() {
        return Platform.getRecipeManager().map(recipeManager -> recipeManager.method_30027(PollenRecipeTypes.BREWING_TYPE.get())).orElse(Collections.emptyList());
    }

    @Inject(method={"isPotionIngredient"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isPotionIngredient(class_1799 itemStack, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (!recipe.getIngredient().method_8093(itemStack)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"isBrewablePotion"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isBrewablePotion(class_1842 potion, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> list = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipes : list) {
            if (recipes.getResult() != potion) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"hasPotionMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasPotionMix(class_1799 potionStack, class_1799 ingredient, CallbackInfoReturnable<Boolean> cir) {
        class_1842 potion = class_1844.method_8063((class_1799)potionStack);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().method_8093(ingredient)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mix(class_1799 ingredient, class_1799 fromPotion, CallbackInfoReturnable<class_1799> cir) {
        if (ingredient.method_7960()) {
            return;
        }
        class_1842 potion = class_1844.method_8063((class_1799)fromPotion);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().method_8093(ingredient)) continue;
            cir.setReturnValue((Object)class_1844.method_8061((class_1799)new class_1799((class_1935)fromPotion.method_7909()), (class_1842)recipe.getResult()));
            return;
        }
    }
}

