/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.event.events.entity.ModifyGravityEvent;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private int captureAirSupply;

    @Shadow
    protected abstract int method_6130(int var1);

    @Shadow
    public abstract boolean method_6094();

    @Shadow
    protected abstract void method_6010(class_3494<class_3611> var1);

    @Shadow
    public abstract void method_29242(class_1309 var1, boolean var2);

    @Shadow
    protected abstract boolean method_29920();

    @Shadow
    public abstract boolean method_26319(class_3611 var1);

    private LivingEntityMixin(class_1299<? extends class_1297> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    public void captureState(CallbackInfo ci) {
        this.captureAirSupply = this.method_5669();
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z", shift=At.Shift.BEFORE)})
    public void tickFluidDrowning(CallbackInfo ci) {
        if (this.method_5805()) {
            PollenFluidBehavior behavior;
            PollenFluidBehavior pollenFluidBehavior = behavior = this.field_25599 != null ? FluidBehaviorRegistry.get((class_3494<class_3611>)this.field_25599) : null;
            if (behavior == null) {
                return;
            }
            class_1309 livingEntity = (class_1309)this;
            if (!behavior.shouldEntityDrown(livingEntity)) {
                return;
            }
            if (!(this.method_6094() || class_1292.method_5574((class_1309)livingEntity) || this instanceof class_1657 && ((class_1657)livingEntity).method_31549().field_7480)) {
                this.method_5855(this.captureAirSupply);
                this.method_5855(this.method_6130(this.method_5669()));
                if (this.method_5669() == -20) {
                    this.method_5855(0);
                    class_243 vec3 = this.method_18798();
                    class_2394 particle = behavior.getDrowningParticles(livingEntity);
                    if (particle != null) {
                        for (int i = 0; i < 8; ++i) {
                            double f = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            double g = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            double h = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            this.field_6002.method_8406(particle, this.method_23317() + f, this.method_23318() + g, this.method_23321() + h, vec3.field_1352, vec3.field_1351, vec3.field_1350);
                        }
                    }
                    this.method_5643(class_1282.field_5859, behavior.getDrowningDamage(livingEntity));
                }
            }
            if (!this.field_6002.method_8608() && this.method_5765() && this.method_5854() != null && !behavior.canVehicleTraverse(livingEntity, this.method_5854())) {
                this.method_5848();
            }
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    public void updateCustomFluid(double y, boolean onGround, class_2680 state, class_2338 pos, CallbackInfo ci) {
        FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.method_5861((class_3494)tag) == 0.0).forEach(tag -> FluidBehaviorRegistry.doFluidPushing((class_3494<class_3611>)tag, this));
    }

    @ModifyVariable(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidJumpThreshold()D", shift=At.Shift.BEFORE), ordinal=0)
    public boolean modifyInWater(boolean value) {
        return value || FluidBehaviorRegistry.getFluids().stream().anyMatch(tag -> this.method_5861((class_3494)tag) > 0.0);
    }

    @Inject(method={"jumpInLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    public void jumpInLiquid(class_3494<class_3611> fluidTag, CallbackInfo ci) {
        if (!this.method_5799() && fluidTag == class_3486.field_15517) {
            FluidBehaviorRegistry.getFluids().stream().filter(tag -> Objects.requireNonNull(FluidBehaviorRegistry.get((class_3494<class_3611>)tag)).canAscend((class_1309)this) && this.method_5861((class_3494)tag) > 0.0).findFirst().ifPresent(this::method_6010);
            ci.cancel();
        }
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void travelInCustomFluid(class_243 travelVector, CallbackInfo ci, double fallSpeed) {
        if (this.method_29920() && !this.method_26319(this.field_6002.method_8316(this.method_24515()).method_15772())) {
            FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.method_5861((class_3494)tag) > 0.0).forEach(tag -> {
                PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((class_3494<class_3611>)tag));
                behavior.applyPhysics((class_1309)this, travelVector, fallSpeed, this.method_18798().field_1351 <= 0.0);
                ci.cancel();
            });
            if (ci.isCancelled()) {
                this.method_29242((class_1309)this, this instanceof class_1432);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        TickEvents.LIVING_POST.invoker().tick((class_1309)this);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;", shift=At.Shift.BEFORE))
    public double modifyGravity(double gravity) {
        return ModifyGravityEvent.EVENT.invoker().modifyGravity((class_1309)this, gravity);
    }
}

