/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.RenderableCosmetic;
import gg.moonflower.pollen.core.client.entitlement.type.SimpleCosmetic;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModelCosmetic
extends SimpleCosmetic
implements RenderableCosmetic {
    public static final Codec<ModelCosmetic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("modelUrl").forGetter(cosmetic -> cosmetic.getModelUrls()[0]), (App)Codec.STRING.fieldOf("modelKey").forGetter(cosmetic -> Objects.requireNonNull(cosmetic.getModelKey()).method_12832()), (App)GeometryModelTextureTable.CODEC.fieldOf("textureTable").forGetter(ModelCosmetic::getTextureTable)).apply((Applicative)instance, ModelCosmetic::new));
    private final String[] modelUrl;
    private final class_2960 modelKey;
    private final GeometryModelTextureTable textureTable;

    public ModelCosmetic(String modelUrl, String modelKey, GeometryModelTextureTable textureTable) {
        this.modelUrl = new String[]{modelUrl};
        this.modelKey = new class_2960("pollen", modelKey);
        this.textureTable = textureTable;
    }

    @Override
    protected Entitlement copyData() {
        return new ModelCosmetic(this.modelUrl[0], this.modelKey.method_12832(), this.textureTable);
    }

    @Override
    public Entitlement.Type getType() {
        return Entitlement.Type.COSMETIC;
    }

    @Override
    public void registerTextures(BiConsumer<class_2960, GeometryModelTextureTable> textureConsumer) {
        textureConsumer.accept(this.getRegistryName(), this.textureTable);
    }

    @Override
    public class_2960 getTextureKey() {
        return this.getRegistryName();
    }

    @Override
    public String[] getModelUrls() {
        return this.modelUrl;
    }

    @Override
    public class_2960 getModelKey() {
        return this.modelKey;
    }

    public GeometryModelTextureTable getTextureTable() {
        return this.textureTable;
    }
}

