/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement.type;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.RenderableCosmetic;
import gg.moonflower.pollen.core.client.screen.button.ArrayEntry;
import gg.moonflower.pollen.core.client.screen.button.EntitlementEntry;
import gg.moonflower.pollen.core.client.screen.button.ToggleEntry;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractHalo
extends Entitlement
implements RenderableCosmetic {
    private boolean emissive;
    private Visibility visibility;
    private Display display;

    @Override
    public void updateSettings(JsonObject settings) {
        if (settings.has("emissive")) {
            this.setEmissive(class_3518.method_15270((JsonObject)settings, (String)"emissive"));
        }
        if (settings.has("visibility")) {
            this.setVisibility(Visibility.byName(class_3518.method_15265((JsonObject)settings, (String)"visibility")));
        }
        if (settings.has("display")) {
            this.setDisplay(Display.byName(class_3518.method_15265((JsonObject)settings, (String)"display")));
        }
    }

    @Override
    public JsonObject saveSettings() {
        JsonObject settings = new JsonObject();
        settings.addProperty("emissive", Boolean.valueOf(this.emissive));
        settings.addProperty("visibility", this.visibility.name().toLowerCase(Locale.ROOT));
        settings.addProperty("display", this.display.name().toLowerCase(Locale.ROOT));
        return settings;
    }

    @Override
    public void addEntries(Consumer<EntitlementEntry> entryConsumer) {
        entryConsumer.accept(new ArrayEntry<Visibility>((class_2561)new class_2585("Visibility"), this, v -> {
            this.visibility = v;
        }, this.visibility, Visibility.values()));
        entryConsumer.accept(new ArrayEntry<Display>((class_2561)new class_2585("Display"), this, v -> {
            this.display = v;
        }, this.display, Display.values()));
        entryConsumer.accept(new ToggleEntry((class_2561)new class_2585("Emissive"), this, v -> {
            this.emissive = v;
        }, this.emissive));
    }

    @Nullable
    protected abstract HaloData getData();

    @Override
    @Nullable
    public class_2960 getModelKey() {
        HaloData data = this.getData();
        return data != null ? this.display.getter.apply(data) : null;
    }

    @Override
    public boolean isEnabled() {
        return this.visibility != Visibility.OFF;
    }

    @Override
    public float getAlpha() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || this.getVisibility() != Visibility.MOONLIGHT) {
            return 1.0f;
        }
        float brightness = level.method_23787(class_310.method_1551().method_1488()) / 0.5f;
        return brightness * brightness;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setEmissive(boolean emissive) {
        this.emissive = emissive;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public static enum Visibility {
        OFF,
        ON,
        MOONLIGHT;


        public static Visibility byName(String name) {
            for (Visibility type : Visibility.values()) {
                if (!name.equals(type.name().toLowerCase(Locale.ROOT))) continue;
                return type;
            }
            return OFF;
        }
    }

    public static enum Display {
        DEFAULT(HaloData::getDefaultModelKey),
        HORIZONTAL(HaloData::getHorizontalModelKey),
        VERTICAL(HaloData::getVerticalModelKey);

        private final Function<HaloData, class_2960> getter;

        private Display(Function<HaloData, class_2960> getter) {
            this.getter = getter;
        }

        public static Display byName(String name) {
            for (Display type : Display.values()) {
                if (!name.equals(type.name().toLowerCase(Locale.ROOT))) continue;
                return type;
            }
            return DEFAULT;
        }
    }

    public static class HaloData {
        public static final Codec<HaloData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("modelUrl").forGetter(HaloData::getModelUrl), (App)Codec.STRING.fieldOf("defaultModelKey").forGetter(data -> data.getDefaultModelKey().method_12832()), (App)Codec.STRING.fieldOf("horizontalModelKey").forGetter(data -> data.getHorizontalModelKey().method_12832()), (App)Codec.STRING.fieldOf("verticalModelKey").forGetter(data -> data.getVerticalModelKey().method_12832()), (App)GeometryModelTextureTable.CODEC.fieldOf("textureTable").forGetter(HaloData::getTextureTable)).apply((Applicative)instance, HaloData::new));
        private final String modelUrl;
        private final class_2960 defaultModelKey;
        private final class_2960 horizontalModelKey;
        private final class_2960 verticalModelKey;
        private final GeometryModelTextureTable textureTable;

        public HaloData(String modelUrl, String defaultModelKey, String horizontalModelKey, String verticalModelKey, GeometryModelTextureTable textureTable) {
            this.modelUrl = modelUrl;
            this.defaultModelKey = new class_2960("pollen", defaultModelKey);
            this.horizontalModelKey = new class_2960("pollen", horizontalModelKey);
            this.verticalModelKey = new class_2960("pollen", verticalModelKey);
            this.textureTable = textureTable;
        }

        public String getModelUrl() {
            return this.modelUrl;
        }

        public class_2960 getDefaultModelKey() {
            return this.defaultModelKey;
        }

        public class_2960 getHorizontalModelKey() {
            return this.horizontalModelKey;
        }

        public class_2960 getVerticalModelKey() {
            return this.verticalModelKey;
        }

        public GeometryModelTextureTable getTextureTable() {
            return this.textureTable;
        }
    }
}

