/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import gg.moonflower.pollen.api.command.PollenSuggestionProviders;
import gg.moonflower.pollen.api.command.argument.ColorArgumentType;
import gg.moonflower.pollen.api.command.argument.EnumArgument;
import gg.moonflower.pollen.api.command.argument.TimeArgumentType;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.event.events.lifecycle.ServerLifecycleEvents;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.ResourceConditionRegistry;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierManager;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import gg.moonflower.pollen.core.DebugInputs;
import gg.moonflower.pollen.core.PollenTest;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.loader.CosmeticModelLoader;
import gg.moonflower.pollen.core.client.loader.CosmeticTextureLoader;
import gg.moonflower.pollen.core.client.render.PollenShaderTypes;
import gg.moonflower.pollen.core.datagen.PollenLanguageProvider;
import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.resource.condition.ConfigResourceCondition;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.VanillaModelMapping;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2405;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Pollen {
    public static final String MOD_ID = "pollen";
    public static final Platform PLATFORM = Platform.builder("pollen").commonInit(Pollen::onCommon).clientInit(Pollen::onClient).commonPostInit(Pollen::onCommonPost).clientPostInit(Pollen::onClientPost).dataInit(Pollen::onDataInit).build();
    private static MinecraftServer server;

    public static void init() {
        PollenSuggestionProviders.init();
        if (!Platform.isProduction()) {
            PollenTest.init();
        }
    }

    private static void onClient() {
        VanillaModelMapping.load();
        SyncedDataManager.initClient();
        ResourceModifierManager.initClient();
        GeometryModelManager.init();
        GeometryTextureManager.init();
        AnimationManager.init();
        PollenShaderTypes.init();
        GeometryModelManager.addLoader(new CosmeticModelLoader());
        GeometryTextureManager.addProvider(new CosmeticTextureLoader());
        DebugInputs.init();
        EntitlementManager.init();
        if (!Platform.isProduction()) {
            PollenTest.onClient();
        }
    }

    private static void onCommon() {
        SyncedDataManager.init();
        ResourceModifierManager.init();
        ResourceConditionRegistry.register(ConfigResourceCondition.NAME, new ConfigResourceCondition());
        PollenRecipeTypes.RECIPE_SERIALIZERS.register(PLATFORM);
        PollenRecipeTypes.RECIPES.register(PLATFORM);
        if (!Platform.isProduction()) {
            PollenTest.onCommon();
        }
    }

    private static void onClientPost(Platform.ModSetupContext context) {
        if (!Platform.isProduction()) {
            PollenTest.onClientPost(context);
        }
    }

    private static void onCommonPost(Platform.ModSetupContext context) {
        class_2316.method_10017((String)"pollen:color", ColorArgumentType.class, (class_2314)new class_2319(ColorArgumentType::new));
        class_2316.method_10017((String)"pollen:time", TimeArgumentType.class, (class_2314)new TimeArgumentType.Serializer());
        class_2316.method_10017((String)"pollen:enum", EnumArgument.class, (class_2314)new EnumArgument.Serializer());
        ServerLifecycleEvents.PRE_STARTING.register(server -> {
            Pollen.server = server;
            return true;
        });
        ServerLifecycleEvents.STOPPED.register(server -> {
            Pollen.server = null;
        });
        PollenMessages.init();
        if (!Platform.isProduction()) {
            PollenTest.onCommonPost(context);
        }
    }

    private static void onDataInit(Platform.DataSetupContext context) {
        context.getGenerator().method_10314((class_2405)new PollenLanguageProvider(context.getGenerator(), context.getMod()));
        if (!Platform.isProduction()) {
            PollenTest.onDataInit(context);
        }
    }

    @Nullable
    public static MinecraftServer getRunningServer() {
        return server;
    }
}

