/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import com.google.common.base.Stopwatch;
import gg.moonflower.pollen.api.client.util.TextureDownloader;
import gg.moonflower.pollen.api.event.events.client.InputEvents;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.profile.ProfileManager;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class DebugInputs {
    static void init() {
        InputEvents.KEY_INPUT_EVENT.register(DebugInputs::onKeyInput);
    }

    private static boolean onKeyInput(int key, int scanCode, int action, int modifiers) {
        if (Platform.isProduction() || class_310.method_1551().field_1755 instanceof class_408 || action != 1) {
            return false;
        }
        if (key == 92) {
            class_746 player = class_310.method_1551().field_1724;
            if ((modifiers & 4) > 0) {
                if (player == null) {
                    return true;
                }
                Stopwatch timer = Stopwatch.createStarted();
                UUID id = class_310.method_1551().method_1548().method_1677().getId();
                ProfileManager.clearCache(id);
                EntitlementManager.clearCache();
                CompletableFuture.allOf(new CompletableFuture[]{GeometryModelManager.reload(false), GeometryTextureManager.reload(false), AnimationManager.reload(false), EntitlementManager.reload(true, CompletableFuture::completedFuture, (Executor)class_310.method_1551()).thenCompose(__ -> EntitlementManager.getEntitlementsFuture(id))}).handle((u, t) -> {
                    timer.stop();
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)new class_2585("").method_10852((class_2561)new class_2588("debug.prefix").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_27693(" Took " + timer + " to reload entitlements"));
                    return u;
                });
                return true;
            }
            try {
                Path outputFolder = Paths.get(class_310.method_1551().field_1697.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < 1024; ++i) {
                    if (!GL11C.glIsTexture((int)i)) continue;
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i));
                }
                class_156.method_33791(result).thenRunAsync(() -> class_156.method_668().method_672(outputFolder.toFile()), (Executor)class_310.method_1551());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

