/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.common.trades;

import gg.moonflower.pollen.api.event.events.entity.ModifyTradesEvents;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VillagerTradeManager {
    private static final Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> VANILLA_TRADES = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>();
    private static final Int2ObjectMap<class_3853.class_1652[]> WANDERER_TRADES = new Int2ObjectOpenHashMap();

    public static void init() {
        VillagerTradeManager.registerWandererTrades();
        VillagerTradeManager.registerVillagerTrades();
    }

    private static void registerWandererTrades() {
        final ModifyTradesEvents.TradeRegistry generic = new ModifyTradesEvents.TradeRegistry();
        final ModifyTradesEvents.TradeRegistry rare = new ModifyTradesEvents.TradeRegistry();
        generic.addAll((Collection<? extends class_3853.class_1652>)Arrays.asList((class_3853.class_1652[])WANDERER_TRADES.get(1)));
        rare.addAll((Collection<? extends class_3853.class_1652>)Arrays.asList((class_3853.class_1652[])WANDERER_TRADES.get(2)));
        ModifyTradesEvents.WANDERER.invoker().modifyTrades(new ModifyTradesEvents.ModifyWanderer.Context(){

            @Override
            public ModifyTradesEvents.TradeRegistry getGeneric() {
                return generic;
            }

            @Override
            public ModifyTradesEvents.TradeRegistry getRare() {
                return rare;
            }
        });
        class_3853.field_17724.put(1, (Object)generic.toArray(new class_3853.class_1652[0]));
        class_3853.field_17724.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static void registerVillagerTrades() {
        for (final class_3852 prof : class_2378.field_17167) {
            Int2ObjectOpenHashMap vanillaTrades = VANILLA_TRADES.get(prof);
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                newTrades.put(i, (Object)new ModifyTradesEvents.TradeRegistry());
            }
            if (vanillaTrades == null) {
                vanillaTrades = new Int2ObjectOpenHashMap();
            }
            vanillaTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradeManager.lambda$registerVillagerTrades$3((Int2ObjectMap)newTrades, arg_0));
            ModifyTradesEvents.VILLAGER.invoker().modifyTrades(new ModifyTradesEvents.ModifyVillager.Context(){
                final /* synthetic */ Int2ObjectMap val$newTrades;
                {
                    this.val$newTrades = int2ObjectMap;
                }

                @Override
                public class_3852 getProfession() {
                    return prof;
                }

                @Override
                public ModifyTradesEvents.TradeRegistry getTrades(int tier) {
                    Validate.exclusiveBetween((long)0L, (long)6L, (long)tier, (String)"Tier must be between 1 and 5");
                    return (ModifyTradesEvents.TradeRegistry)this.val$newTrades.get(tier);
                }
            });
            Int2ObjectOpenHashMap modifiedTrades = new Int2ObjectOpenHashMap();
            newTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradeManager.lambda$registerVillagerTrades$4((Int2ObjectMap)modifiedTrades, arg_0));
            class_3853.field_17067.put(prof, modifiedTrades);
        }
    }

    private static /* synthetic */ void lambda$registerVillagerTrades$4(Int2ObjectMap modifiedTrades, Int2ObjectMap.Entry e) {
        modifiedTrades.put(e.getIntKey(), (Object)((ModifyTradesEvents.TradeRegistry)e.getValue()).toArray(new class_3853.class_1652[0]));
    }

    private static /* synthetic */ void lambda$registerVillagerTrades$3(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        Validate.exclusiveBetween((long)0L, (long)6L, (long)e.getIntKey(), (String)"Tier must be between 1 and 5");
        Arrays.stream((class_3853.class_1652[])e.getValue()).forEach(((ModifyTradesEvents.TradeRegistry)newTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$static$0(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        copy.put(ent.getIntKey(), (Object)Arrays.copyOf((class_3853.class_1652[])ent.getValue(), ((class_3853.class_1652[])ent.getValue()).length));
    }

    static {
        class_3853.field_17067.forEach((key, value) -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            value.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradeManager.lambda$static$0((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((class_3852)key, (Int2ObjectMap<class_3853.class_1652[]>)copy);
        });
        class_3853.field_17724.int2ObjectEntrySet().forEach(e -> WANDERER_TRADES.put(e.getIntKey(), (Object)Arrays.copyOf((class_3853.class_1652[])e.getValue(), ((class_3853.class_1652[])e.getValue()).length)));
    }
}

