/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;

public final class VoxelShapeHelper {
    private VoxelShapeHelper() {
    }

    public static class_265 makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, class_2350.field_11034);
            case class_2350.class_2351.field_11052 -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, class_2350.field_11036);
            case class_2350.class_2351.field_11051 -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, class_2350.field_11035);
        };
    }

    public static class_265 makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> class_2248.method_9541((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2);
            case class_2350.field_11033 -> class_2248.method_9541((double)x1, (double)(16.0 - z2), (double)y1, (double)x2, (double)(16.0 - z1), (double)y2);
            case class_2350.field_11043 -> class_2248.method_9541((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case class_2350.field_11034 -> class_2248.method_9541((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            case class_2350.field_11035 -> class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case class_2350.field_11039 -> class_2248.method_9541((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
        };
    }

    public static final class Builder {
        private final Set<class_265> shapes;

        public Builder() {
            this.shapes = new HashSet<class_265>();
        }

        public Builder(Builder other) {
            this.shapes = new HashSet<class_265>(other.shapes);
        }

        private Builder transformRaw(Function<class_238, class_265> transformer) {
            Builder newBuilder = new Builder();
            for (class_265 shape : this.shapes) {
                HashSet<class_265> rotatedShapes = new HashSet<class_265>();
                for (class_238 box : shape.method_1090()) {
                    rotatedShapes.add(transformer.apply(box));
                }
                class_265 result = class_259.method_1073();
                for (class_265 rotatedShape : rotatedShapes) {
                    result = class_259.method_1082((class_265)result, (class_265)rotatedShape, (class_247)class_247.field_1366);
                }
                newBuilder.append(result.method_1097());
            }
            return newBuilder;
        }

        public Builder append(class_265 ... shapes) {
            this.shapes.addAll(Arrays.asList(shapes));
            return this;
        }

        public Builder append(Builder other) {
            this.shapes.addAll(other.shapes);
            return this;
        }

        public Builder translate(double x, double y, double z) {
            return this.transformRaw(box -> class_2248.method_9541((double)(box.field_1323 * 16.0 + x), (double)(box.field_1322 * 16.0 + y), (double)(box.field_1321 * 16.0 + z), (double)(box.field_1320 * 16.0 + x), (double)(box.field_1325 * 16.0 + y), (double)(box.field_1324 * 16.0 + z)));
        }

        public Builder rotate(class_2350.class_2351 axis) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.field_1323 * 16.0, box.field_1322 * 16.0, box.field_1321 * 16.0, box.field_1320 * 16.0, box.field_1325 * 16.0, box.field_1324 * 16.0, axis));
        }

        public Builder rotate(class_2350 direction) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.field_1323 * 16.0, box.field_1322 * 16.0, box.field_1321 * 16.0, box.field_1320 * 16.0, box.field_1325 * 16.0, box.field_1324 * 16.0, direction));
        }

        public Builder scale(double x, double y, double z) {
            return this.transformRaw(box -> class_2248.method_9541((double)(box.field_1323 * 16.0 * x), (double)(box.field_1322 * 16.0 * y), (double)(box.field_1321 * 16.0 * z), (double)(box.field_1320 * 16.0 * x), (double)(box.field_1325 * 16.0 * y), (double)(box.field_1324 * 16.0 * z)));
        }

        public class_265 build() {
            return this.build(class_247.field_1366);
        }

        public class_265 build(class_247 combineFunction) {
            if (this.shapes.isEmpty()) {
                return class_259.method_1073();
            }
            class_265 result = class_259.method_1073();
            for (class_265 shape : this.shapes) {
                result = class_259.method_1082((class_265)result, (class_265)shape, (class_247)combineFunction);
            }
            return result.method_1097();
        }
    }
}

