/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import java.util.function.BiPredicate;

public enum NumberCompareMode implements BiPredicate<Number, Number>
{
    GREATER_THAN(">", (t, u) -> t.doubleValue() > u.doubleValue()),
    LESS_THAN("<", (t, u) -> t.doubleValue() < u.doubleValue()),
    GREATER_THAN_OR_EQUAL(">=", (t, u) -> t.doubleValue() >= u.doubleValue()),
    LESS_THAN_OR_EQUAL("<=", (t, u) -> t.doubleValue() <= u.doubleValue()),
    EQUAL("=", (t, u) -> t.doubleValue() == u.doubleValue());

    private final String symbol;
    private final BiPredicate<Number, Number> comparator;

    private NumberCompareMode(String symbol, BiPredicate<Number, Number> comparator) {
        this.symbol = symbol;
        this.comparator = comparator;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean test(Number t, Number u) {
        return this.comparator.test(t, u);
    }

    public static NumberCompareMode byName(String name) {
        for (NumberCompareMode mode : NumberCompareMode.values()) {
            if (!mode.name().toLowerCase(Locale.ROOT).equals(name) && !mode.symbol.equals(name)) continue;
            return mode;
        }
        throw new JsonSyntaxException("Unknown compare mode: " + name);
    }
}

