/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public abstract class DynamicInventory
implements class_1263 {
    private final Int2ObjectOpenHashMap<class_1799> inventory = new Int2ObjectOpenHashMap();
    private Set<class_1265> listeners = null;

    private int getNextEmptySlot(class_1799 stack, int loopStart, int loopEnd) {
        for (int i = loopStart; i < loopEnd; ++i) {
            if (!this.method_5437(i, stack) || !((class_1799)this.inventory.getOrDefault(i, (Object)class_1799.field_8037)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private void mergeStacks(class_1799 stack, class_1799 stackInSlot, int index) {
        int maxStackSize = Math.min(this.getSlotStackLimit(index), stackInSlot.method_7914());
        int addAmount = Math.min(stack.method_7947(), maxStackSize - stackInSlot.method_7947());
        if (addAmount > 0) {
            stackInSlot.method_7933(addAmount);
            stack.method_7934(addAmount);
        }
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<class_1265>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public class_1799 addItem(class_1799 stack) {
        return this.addItem(stack, 0, this.method_5439());
    }

    public class_1799 addItem(class_1799 stack, int startIndex, int endIndex) {
        int index;
        int loopStart = Math.max(0, startIndex);
        int loopEnd = Math.min(this.method_5439(), endIndex);
        class_1799 copy = stack.method_7972();
        for (int i = loopStart; i < loopEnd; ++i) {
            class_1799 stackInSlot = this.method_5438(i);
            if (!this.method_5437(i, stack) || !class_1799.method_7984((class_1799)stackInSlot, (class_1799)copy) || !class_1799.method_7975((class_1799)stackInSlot, (class_1799)copy)) continue;
            this.mergeStacks(copy, stackInSlot, i);
            if (!copy.method_7960()) continue;
            this.method_5431();
            return class_1799.field_8037;
        }
        while (!copy.method_7960() && (index = this.getNextEmptySlot(copy, loopStart, loopEnd)) >= 0) {
            if (copy.method_7947() > this.getSlotStackLimit(index)) {
                this.inventory.put(index, (Object)copy.method_7971(this.getSlotStackLimit(index)));
                continue;
            }
            this.inventory.put(index, (Object)copy.method_7972());
            copy = class_1799.field_8037;
        }
        if (!class_1799.method_7973((class_1799)stack, (class_1799)copy)) {
            this.method_5431();
        }
        return copy;
    }

    public boolean isFull() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 s = this.method_5438(i);
            if (!s.method_7960() && s.method_7947() >= s.method_7914()) continue;
            return false;
        }
        return true;
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.inventory.getOrDefault(index, (Object)class_1799.field_8037);
    }

    public class_1799 method_5434(int index, int count) {
        if (((class_1799)this.inventory.getOrDefault(index, (Object)class_1799.field_8037)).method_7960() || count <= 0) {
            return class_1799.field_8037;
        }
        class_1799 stack = ((class_1799)this.inventory.getOrDefault(index, (Object)class_1799.field_8037)).method_7971(count);
        this.method_5431();
        return stack;
    }

    public class_1799 method_5441(int index) {
        if (((class_1799)this.inventory.getOrDefault(index, (Object)class_1799.field_8037)).method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 stack = (class_1799)this.inventory.remove(index);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        this.method_5431();
        return stack;
    }

    public void method_5447(int index, class_1799 stack) {
        if (index < 0 || index >= this.method_5439()) {
            return;
        }
        this.inventory.put(index, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.getSlotStackLimit(index)) {
            stack.method_7939(this.getSlotStackLimit(index));
        }
        this.method_5431();
    }

    public void method_5431() {
        if (this.listeners == null) {
            return;
        }
        for (class_1265 listener : this.listeners) {
            listener.method_5453((class_1263)this);
        }
    }

    public int getSlotStackLimit(int index) {
        return this.method_5444();
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void write(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = (class_1799)this.inventory.getOrDefault(i, (Object)class_1799.field_8037);
            if (stack.method_7960()) continue;
            class_2487 slotNbt = new class_2487();
            slotNbt.method_10567("Slot", (byte)i);
            stack.method_7953(slotNbt);
            list.add((Object)slotNbt);
        }
        nbt.method_10566("Items", (class_2520)list);
    }

    public void read(class_2487 nbt) {
        this.method_5448();
        class_2499 list = nbt.method_10554("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 slotNbt = list.method_10602(i);
            int index = slotNbt.method_10571("Slot") & 0xFF;
            if (index >= this.method_5439()) continue;
            this.inventory.put(index, (Object)class_1799.method_7915((class_2487)slotNbt));
        }
    }
}

