/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.fabric.SyncedDataManagerImpl;
import gg.moonflower.pollen.core.network.login.ClientboundSyncPlayerDataKeysPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SyncedDataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_2960, SyncedDataKey<?>> REGISTERED_KEYS = new HashMap();
    private static final Map<Integer, SyncedDataKey<?>> KEY_LOOKUP = new Int2ObjectArrayMap();
    private static final Map<Integer, SyncedDataKey<?>> CLIENT_KEY_LOOKUP = new Int2ObjectArrayMap();
    private static int nextId;
    private static boolean dirty;

    private SyncedDataManager() {
    }

    private static Map<Integer, SyncedDataKey<?>> getKeyLookup() {
        return !CLIENT_KEY_LOOKUP.isEmpty() ? CLIENT_KEY_LOOKUP : KEY_LOOKUP;
    }

    @ApiStatus.Internal
    public static void init() {
        TickEvents.SERVER_POST.register(() -> {
            dirty = false;
        });
        TickEvents.LIVING_POST.register(entity -> {
            if (dirty) {
                SyncedDataManager.sync((class_1297)entity);
            }
        });
    }

    @ApiStatus.Internal
    public static void initClient() {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> CLIENT_KEY_LOOKUP.clear());
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sync(class_1297 entity) {
        SyncedDataManagerImpl.sync(entity);
    }

    @ApiStatus.Internal
    public static void syncKeys(ClientboundSyncPlayerDataKeysPacket pkt) {
        CLIENT_KEY_LOOKUP.clear();
        pkt.getMappings().forEach((name, id) -> {
            SyncedDataKey<?> key = SyncedDataManager.byName(name);
            if (key == null) {
                LOGGER.error("Server sent mapping for unknown key: " + name);
                return;
            }
            CLIENT_KEY_LOOKUP.put((Integer)id, key);
        });
    }

    @ApiStatus.Internal
    public static void markDirty() {
        dirty = true;
    }

    public static synchronized void register(SyncedDataKey<?> key) {
        if (REGISTERED_KEYS.put(key.getKey(), key) != null) {
            throw new IllegalStateException("Duplicate data key: " + key.getKey());
        }
        KEY_LOOKUP.put(nextId++, key);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void set(class_1297 entity, SyncedDataKey<T> key, T value) {
        void var2_2;
        void var1_1;
        SyncedDataManagerImpl.set(entity, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> T get(class_1297 player, SyncedDataKey<T> key) {
        void var1_1;
        return SyncedDataManagerImpl.get(player, var1_1);
    }

    @Nullable
    public static SyncedDataKey<?> byName(class_2960 name) {
        return REGISTERED_KEYS.get(name);
    }

    public static int getId(SyncedDataKey<?> key) {
        return SyncedDataManager.getKeyLookup().entrySet().stream().filter(entry -> entry.getValue() == key).mapToInt(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalStateException("Attempted to get id of unregistered key: " + key.getKey()));
    }

    public static SyncedDataKey<?> byId(int id) {
        if (!SyncedDataManager.getKeyLookup().containsKey(id)) {
            throw new IllegalStateException("Unknown synced data key with id: " + id);
        }
        return SyncedDataManager.getKeyLookup().get(id);
    }

    public static Stream<Integer> getIds() {
        return SyncedDataManager.getKeyLookup().keySet().stream();
    }
}

