/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class DataComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<SyncedDataKey<?>, Object> values = new HashMap();
    protected final Set<Integer> dirtyValues = ConcurrentHashMap.newKeySet();

    protected DataComponent() {
    }

    public <T> T getValue(SyncedDataKey<T> key) {
        return (T)this.values.computeIfAbsent(key, k -> k.getDefaultValueSupplier().get());
    }

    public <T> void setValue(SyncedDataKey<T> key, T value) {
        T oldValue = this.getValue(key);
        this.values.put(key, value);
        if (!Objects.equals(oldValue, value)) {
            this.dirtyValues.add(SyncedDataManager.getId(key));
        }
    }

    public boolean shouldSyncWith(class_1297 provider, class_1297 entity) {
        return this.values.keySet().stream().map(key -> provider == entity && key.getSyncStrategy().isSyncEntity() || key.getSyncStrategy().isSyncTracking()).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory) {
        return this.values.keySet().stream().map(SyncedDataKey::isPersistent).reduce(false, (a, b) -> a != false || b != false);
    }

    public void copyForRespawn(DataComponent original, boolean lossless) {
        class_2487 tag = new class_2487();
        original.writeToNbt(tag, lossless ? NbtWriteMode.COPY : NbtWriteMode.RESPAWN);
        this.readFromNbt(tag);
    }

    public void clean() {
        this.dirtyValues.clear();
    }

    public boolean isDirty() {
        return !this.dirtyValues.isEmpty();
    }

    public void readFromNbt(class_2487 nbt) {
        for (String key : nbt.method_10541()) {
            class_2520 tag = nbt.method_10580(key);
            try {
                class_2960 name = new class_2960(key);
                SyncedDataKey<?> syncedDataKey = SyncedDataManager.byName(name);
                if (syncedDataKey == null) {
                    throw new IllegalStateException("Unknown synced data key: " + name);
                }
                this.values.put(syncedDataKey, this.readWithCodec(syncedDataKey, tag));
            }
            catch (Exception e) {
                LOGGER.error("Failed to decode " + key + " from NBT: " + tag, (Throwable)e);
            }
        }
    }

    public void writeToNbt(class_2487 nbt, NbtWriteMode mode) {
        for (Map.Entry<SyncedDataKey<?>, Object> entry : this.values.entrySet()) {
            SyncedDataKey<?> key = entry.getKey();
            if (mode == NbtWriteMode.SAVE && !key.isSave() || mode == NbtWriteMode.RESPAWN && !key.isPersistent()) continue;
            this.writeWithCodec(key).ifPresent(tag -> nbt.method_10566(key.getKey().toString(), tag));
        }
    }

    protected void writePacketData(class_2540 buf, int[] ids) {
        buf.method_10804(ids.length);
        for (int i : ids) {
            buf.method_10804(i);
            SyncedDataKey<?> key = SyncedDataManager.byId(i);
            class_2487 tag = new class_2487();
            this.writeWithCodec(key).ifPresent(data -> tag.method_10566("a", (class_2520)data));
            buf.method_10794(tag);
        }
    }

    public void applySyncPacket(class_2540 buf) {
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            SyncedDataKey<?> key = SyncedDataManager.byId(buf.method_10816());
            class_2487 tag = buf.method_10798();
            if (tag != null && tag.method_10545("a")) {
                this.values.put(key, this.readWithCodec(key, tag.method_10580("a")));
            }
            buf.method_10794(tag);
        }
    }

    protected <T> T readWithCodec(SyncedDataKey<T> key, class_2520 data) {
        DataResult dataResult = key.getCodec().parse((DynamicOps)class_2509.field_11560, (Object)data);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to decode " + key.getKey() + " from NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + data);
            return key.getDefaultValueSupplier().get();
        }
        return dataResult.result().get();
    }

    protected <T> Optional<class_2520> writeWithCodec(SyncedDataKey<T> key) {
        if (!this.values.containsKey(key)) {
            return Optional.empty();
        }
        T value = this.getValue(key);
        DataResult dataResult = key.getCodec().encodeStart((DynamicOps)class_2509.field_11560, value);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to encode " + key.getKey() + " to NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + value);
            return Optional.empty();
        }
        return dataResult.result();
    }

    public static enum NbtWriteMode {
        COPY,
        SAVE,
        RESPAWN;

    }
}

