/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier.type;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifier;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierManager;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.core.mixin.data.AdvancementBuilderAccessor;
import gg.moonflower.pollen.core.mixin.data.AdvancementRewardsAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_193;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5257;
import net.minecraft.class_5350;
import org.apache.commons.lang3.ArrayUtils;

public class AdvancementModifier
extends ResourceModifier<class_161.class_162> {
    private final Map<String, class_175> addCriteria;
    private final String[][] injectRequirements;
    private final String[][] addRequirements;
    private final class_170 addRewards;
    private final String[] removeRequirements;
    private final class_2960[] removeLoot;
    private final class_2960[] removeRecipes;

    public AdvancementModifier(class_2960 id, class_2960[] inject, int priority, Map<String, class_175> addCriteria, String[][] injectRequirements, String[][] addRequirements, class_170 addRewards, String[] removeRequirements, class_2960[] removeLoot, class_2960[] removeRecipes) {
        super(id, inject, priority);
        this.addCriteria = ImmutableMap.copyOf(addCriteria);
        this.injectRequirements = injectRequirements;
        this.addRequirements = addRequirements;
        this.addRewards = addRewards;
        this.removeRequirements = removeRequirements;
        this.removeLoot = removeLoot;
        this.removeRecipes = removeRecipes;
    }

    private String getCriteriaName(String criteria) {
        if (criteria.contains(":")) {
            return criteria;
        }
        if (!this.addCriteria.containsKey(criteria) && this.addCriteria.containsKey(this.id.method_12836() + ":" + criteria)) {
            return this.id.method_12836() + ":" + criteria;
        }
        return criteria;
    }

    public static Builder advancementModifier() {
        return new Builder();
    }

    public Builder deconstruct() {
        return new Builder(this.inject, this.priority, this.addCriteria, this.injectRequirements, this.addRequirements, this.addRewards, this.removeRequirements, this.removeLoot, this.removeRecipes);
    }

    @Override
    public void modify(class_161.class_162 resource) throws JsonParseException {
        int i;
        String[][] stringArray = this.injectRequirements;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] requirement;
            for (String criteria2 : requirement = stringArray[j]) {
                if (this.addCriteria.containsKey(criteria2 = this.getCriteriaName(criteria2)) || resource.method_710().containsKey(criteria2)) continue;
                throw new JsonSyntaxException("Unknown required criterion '" + criteria2 + "'");
            }
        }
        AdvancementBuilderAccessor accessor = (AdvancementBuilderAccessor)resource;
        if (!this.addCriteria.isEmpty()) {
            resource.method_710().putAll(this.addCriteria);
        }
        String[][] requirements = accessor.getRequirements();
        class_170 rewards = ((AdvancementBuilderAccessor)resource).getRewards();
        class_2960[] loot = ((AdvancementRewardsAccessor)rewards).getLoot();
        class_2960[] recipes = ((AdvancementRewardsAccessor)rewards).getRecipes();
        int experience = ((AdvancementRewardsAccessor)rewards).getExperience();
        if (this.removeRequirements.length > 0) {
            String[] stringArray2 = this.removeRequirements;
            int criteria2 = stringArray2.length;
            for (int j = 0; j < criteria2; ++j) {
                String remove = stringArray2[j];
                for (i = 0; i < requirements.length; ++i) {
                    requirements[i] = JSONTupleParser.remove(requirements[i], remove);
                    String[] requirement = requirements[i];
                    if (requirement.length != 0) continue;
                    System.arraycopy(requirements, i + 1, requirements, i, requirements.length - i - 1);
                    requirements = (String[][])Arrays.copyOf(requirements, requirements.length - 1);
                }
            }
            if (requirements.length == 0) {
                throw new JsonSyntaxException("At least 1 requirement must remain after removing requirements");
            }
        }
        if (this.injectRequirements.length > 0) {
            if (this.injectRequirements.length > requirements.length) {
                throw new JsonSyntaxException("Requirements can only be injected up to " + requirements.length + ", got " + this.injectRequirements.length);
            }
            for (int i2 = 0; i2 < this.injectRequirements.length; ++i2) {
                String[] requirement = this.injectRequirements[i2];
                if (requirement.length == 0) continue;
                requirements[i2] = JSONTupleParser.insert(requirements[i2], requirement);
            }
        }
        if (this.addRequirements.length > 0) {
            requirements = (String[][])JSONTupleParser.insert(requirements, this.addRequirements);
        }
        for (String[] requirement : requirements) {
            for (i = 0; i < requirement.length; ++i) {
                requirement[i] = this.getCriteriaName(requirement[i]);
            }
        }
        String[][] finalRequirements = requirements;
        resource.method_710().keySet().removeIf(criteria -> {
            for (Object[] objectArray : finalRequirements) {
                if (!ArrayUtils.contains((Object[])objectArray, (Object)criteria)) continue;
                return false;
            }
            return true;
        });
        accessor.setRequirements(requirements);
        AdvancementRewardsAccessor addRewards = (AdvancementRewardsAccessor)this.addRewards;
        if (this.removeLoot.length > 0) {
            class_2960[] class_2960Array = this.removeLoot;
            int n2 = class_2960Array.length;
            for (int j = 0; j < n2; ++j) {
                class_2960 remove = class_2960Array[j];
                loot = JSONTupleParser.remove(loot, remove);
            }
        }
        if (this.removeRecipes.length > 0) {
            for (class_2960 remove : this.removeRecipes) {
                recipes = JSONTupleParser.remove(recipes, remove);
            }
        }
        if (addRewards.getLoot().length > 0) {
            loot = JSONTupleParser.insert(loot, addRewards.getLoot());
        }
        if (addRewards.getRecipes().length > 0) {
            recipes = JSONTupleParser.insert(recipes, addRewards.getRecipes());
        }
        accessor.setRewards(new class_170(experience += addRewards.getExperience(), loot, recipes, ((AdvancementRewardsAccessor)rewards).getFunction()));
    }

    @Override
    public ResourceModifierType getType() {
        return ResourceModifierManager.ADVANCEMENT.get();
    }

    public static class Builder
    extends ResourceModifier.Builder<AdvancementModifier, Builder> {
        private final Map<String, class_175> addCriteria;
        private final Map<String, Integer> injectRequirementsKeys;
        private final List<String> addRequirementsKeys;
        private final List<String> removeRequirements;
        private final List<class_2960> removeLoot;
        private final List<class_2960> removeRecipes;
        private String[][] injectRequirements;
        private String[][] addRequirements;
        private class_193 requirementsStrategy;
        private class_170 addRewards;

        private Builder(class_2960[] inject, int priority, Map<String, class_175> addCriteria, String[][] injectRequirements, String[][] addRequirements, class_170 addRewards, String[] removeRequirements, class_2960[] removeLoot, class_2960[] removeRecipes) {
            super(inject, priority);
            this.addCriteria = new LinkedHashMap<String, class_175>(addCriteria);
            this.injectRequirementsKeys = new LinkedHashMap<String, Integer>();
            this.addRequirementsKeys = new LinkedList<String>();
            this.injectRequirements = injectRequirements;
            this.addRequirements = addRequirements;
            this.addRewards = addRewards;
            this.requirementsStrategy = class_193.field_16882;
            this.removeRequirements = new LinkedList<String>(Arrays.asList(removeRequirements));
            this.removeLoot = new LinkedList<class_2960>(Arrays.asList(removeLoot));
            this.removeRecipes = new LinkedList<class_2960>(Arrays.asList(removeRecipes));
        }

        private Builder() {
            this.addCriteria = new LinkedHashMap<String, class_175>();
            this.injectRequirementsKeys = new LinkedHashMap<String, Integer>();
            this.addRequirementsKeys = new LinkedList<String>();
            this.injectRequirements = null;
            this.addRequirements = null;
            this.addRewards = class_170.field_1167;
            this.requirementsStrategy = class_193.field_16882;
            this.removeRequirements = new LinkedList<String>();
            this.removeLoot = new LinkedList<class_2960>();
            this.removeRecipes = new LinkedList<class_2960>();
        }

        private static Map<String, class_175> getCriteriaName(Map<String, class_175> criteria, class_5257 context) {
            HashMap<String, class_175> result = new HashMap<String, class_175>(criteria.size());
            criteria.forEach((name, criterion) -> result.put((String)(name.contains(":") ? name : context.method_27795().method_12836() + ":" + name), (class_175)criterion));
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public static Builder fromJson(class_2960 name, class_5350 serverResources, JsonObject json, class_2960[] inject, int priority) {
            void var14_25;
            class_2960[] removeLoot;
            void var14_22;
            int i;
            Map<Object, Object> addCriteria;
            class_170 addRewards;
            class_5257 context = new class_5257(name, serverResources.method_29468());
            class_170 class_1702 = addRewards = json.has("addRewards") ? class_170.method_27912((JsonObject)class_3518.method_15296((JsonObject)json, (String)"addRewards")) : class_170.field_1167;
            if (json.has("addCriteria")) {
                addCriteria = Builder.getCriteriaName(class_175.method_772((JsonObject)class_3518.method_15296((JsonObject)json, (String)"addCriteria"), (class_5257)context), context);
                if (addCriteria.isEmpty()) {
                    throw new JsonSyntaxException("'addCriteria' cannot be empty if it's present");
                }
            } else {
                addCriteria = Collections.emptyMap();
            }
            JsonArray injectRequirementsJson = Objects.requireNonNull(class_3518.method_15292((JsonObject)json, (String)"injectRequirements", (JsonArray)new JsonArray()));
            String[][] injectRequirements = new String[injectRequirementsJson.size()][];
            for (int i2 = 0; i2 < injectRequirementsJson.size(); ++i2) {
                JsonArray requirementsJson = class_3518.method_15252((JsonElement)injectRequirementsJson.get(i2), (String)("injectRequirements[" + i2 + "]"));
                injectRequirements[i2] = new String[requirementsJson.size()];
                for (int j = 0; j < requirementsJson.size(); ++j) {
                    injectRequirements[i2][j] = class_3518.method_15287((JsonElement)requirementsJson.get(j), (String)("injectRequirements[" + i2 + "][" + j + "]"));
                }
            }
            JsonArray addRequirementsJson = Objects.requireNonNull(class_3518.method_15292((JsonObject)json, (String)"addRequirements", (JsonArray)new JsonArray()));
            String[][] addRequirements = new String[addRequirementsJson.size()][];
            for (i = 0; i < addRequirementsJson.size(); ++i) {
                JsonArray requirementsJson = class_3518.method_15252((JsonElement)addRequirementsJson.get(i), (String)("addRequirements[" + i + "]"));
                addRequirements[i] = new String[requirementsJson.size()];
                for (int j = 0; j < requirementsJson.size(); ++j) {
                    addRequirements[i][j] = class_3518.method_15287((JsonElement)requirementsJson.get(j), (String)("addRequirements[" + i + "][" + j + "]"));
                }
            }
            if (injectRequirements.length == 0 && addRequirements.length == 0) {
                addRequirements = new String[addCriteria.size()][];
                i = 0;
                for (String string : addCriteria.keySet()) {
                    addRequirements[i++] = new String[]{string};
                }
            }
            String[][] i2 = addRequirements;
            int requirementsJson = i2.length;
            boolean bl = false;
            while (var14_22 < requirementsJson) {
                String[] requirement = i2[var14_22];
                if (requirement.length == 0) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                ++var14_22;
            }
            String[] removeRequirements = JSONTupleParser.getArray(json, "removeRequirements", new String[0], 0, Function.identity());
            if (json.has("removeRewards")) {
                JsonObject removeRewardsJson = class_3518.method_15296((JsonObject)json, (String)"removeRewards");
                removeLoot = JSONTupleParser.getArray(removeRewardsJson, "loot", new class_2960[0], 0, class_2960::new);
                class_2960[] class_2960Array = JSONTupleParser.getArray(removeRewardsJson, "recipes", new class_2960[0], 0, class_2960::new);
            } else {
                removeLoot = new class_2960[]{};
                class_2960[] class_2960Array = new class_2960[]{};
            }
            return new Builder(inject, priority, addCriteria, injectRequirements, addRequirements, addRewards, removeRequirements, removeLoot, (class_2960[])var14_25);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        protected ResourceModifierType getType() {
            return ResourceModifierManager.ADVANCEMENT.get();
        }

        public Builder addRewards(class_170.class_171 builder) {
            return this.addRewards(builder.method_751());
        }

        public Builder addRewards(class_170 addRewards) {
            this.addRewards = addRewards;
            return this;
        }

        public Builder addCriterion(String name, class_184 triggerInstance) {
            return this.addCriterion(name, new class_175(triggerInstance));
        }

        public Builder addCriterion(String name, class_175 criterion) {
            if (this.addCriteria.put(name, criterion) != null) {
                throw new IllegalArgumentException("Duplicate criterion " + name);
            }
            this.addRequirementsKeys.add(name);
            return this;
        }

        public Builder injectCriterion(String name, int index, class_184 triggerInstance) {
            return this.injectCriterion(name, index, new class_175(triggerInstance));
        }

        public Builder injectCriterion(String name, int index, class_175 criterion) {
            if (this.addCriteria.put(name, criterion) != null) {
                throw new IllegalArgumentException("Duplicate criterion " + name);
            }
            this.injectRequirementsKeys.put(name, index);
            return this;
        }

        public Builder removeLoot(class_2960 lootTable) {
            this.removeLoot.add(lootTable);
            return this;
        }

        public Builder removeRecipe(class_2960 recipeId) {
            this.removeRecipes.add(recipeId);
            return this;
        }

        public Builder addRequirements(class_193 requirementsStrategy) {
            this.requirementsStrategy = requirementsStrategy;
            return this;
        }

        private void initRequirements() {
            if (this.addRequirements == null) {
                this.addRequirements = this.requirementsStrategy.createRequirements(this.addRequirementsKeys);
            }
            if (this.injectRequirements == null) {
                Map.Entry[] entries = (Map.Entry[])this.injectRequirementsKeys.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).toArray(Map.Entry[]::new);
                this.injectRequirements = new String[this.injectRequirementsKeys.values().stream().mapToInt(i -> i).max().orElse(0)][];
                LinkedList<String> list = new LinkedList<String>();
                int currentIndex = 0;
                for (Map.Entry entry : entries) {
                    if ((Integer)entry.getValue() != currentIndex) {
                        this.injectRequirements[currentIndex] = list.toArray(new String[0]);
                        currentIndex = (Integer)entry.getValue();
                        list.clear();
                    }
                    list.add((String)entry.getKey());
                }
                if (!list.isEmpty()) {
                    this.injectRequirements[currentIndex] = list.toArray(new String[0]);
                }
            }
        }

        @Override
        public AdvancementModifier build(class_2960 id) {
            if (this.inject.isEmpty()) {
                throw new IllegalStateException("'inject' must be defined");
            }
            this.initRequirements();
            return new AdvancementModifier(id, this.inject.toArray(new class_2960[0]), this.priority, this.addCriteria, this.injectRequirements, this.addRequirements, this.addRewards, this.removeRequirements.toArray(new String[0]), this.removeLoot.toArray(new class_2960[0]), this.removeRecipes.toArray(new class_2960[0]));
        }

        @Override
        protected void serializeProperties(JsonObject json) {
            this.initRequirements();
            if (!this.addCriteria.isEmpty()) {
                JsonObject addCriteriaJson = new JsonObject();
                for (Map.Entry entry : this.addCriteria.entrySet()) {
                    addCriteriaJson.add((String)entry.getKey(), ((class_175)entry.getValue()).method_773());
                }
                json.add("addCriteria", (JsonElement)addCriteriaJson);
            }
            if (this.addRequirements.length > 0) {
                JsonArray addRequirementsJson = new JsonArray();
                for (String[] addRequirement : this.addRequirements) {
                    JsonArray addRequirementJson = new JsonArray();
                    for (String criterion : addRequirement) {
                        addRequirementJson.add(criterion);
                    }
                    addRequirementsJson.add((JsonElement)addRequirementJson);
                }
                json.add("addRequirements", (JsonElement)addRequirementsJson);
            }
            if (this.injectRequirements.length > 0) {
                JsonArray injectRequirementsJson = new JsonArray();
                for (String[] injectRequirement : this.injectRequirements) {
                    JsonArray injectRequirementJson = new JsonArray();
                    for (String criterion : injectRequirement) {
                        injectRequirementJson.add(criterion);
                    }
                    injectRequirementsJson.add((JsonElement)injectRequirementJson);
                }
                json.add("injectRequirements", (JsonElement)injectRequirementsJson);
            }
            json.add("addRewards", this.addRewards.method_747());
            if (!this.removeRequirements.isEmpty()) {
                JsonArray removeRequirementsJson = new JsonArray();
                for (String string : this.removeRequirements) {
                    removeRequirementsJson.add(string);
                }
                json.add("removeRequirements", (JsonElement)removeRequirementsJson);
            }
            if (!this.removeLoot.isEmpty()) {
                JsonArray removeLootJson = new JsonArray();
                for (class_2960 class_29602 : this.removeLoot) {
                    removeLootJson.add(class_29602.toString());
                }
                json.add("removeLoot", (JsonElement)removeLootJson);
            }
            if (!this.removeRecipes.isEmpty()) {
                JsonArray removeRecipesJson = new JsonArray();
                for (class_2960 class_29603 : this.removeRecipes) {
                    removeRecipesJson.add(class_29603.toString());
                }
                json.add("removeRecipes", (JsonElement)removeRecipesJson);
            }
        }
    }
}

