/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.event.events.AdvancementConstructingEvent;
import gg.moonflower.pollen.api.event.events.LootTableConstructingEvent;
import gg.moonflower.pollen.api.event.events.client.resource.ModelEvents;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ReloadStartListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifier;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import gg.moonflower.pollen.api.resource.modifier.serializer.DataModifierSerializer;
import gg.moonflower.pollen.api.resource.modifier.serializer.ResourceModifierSerializer;
import gg.moonflower.pollen.api.resource.modifier.type.AdvancementModifier;
import gg.moonflower.pollen.api.resource.modifier.type.LootModifier;
import gg.moonflower.pollen.api.resource.modifier.type.ModelOverrideModifier;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5350;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ResourceModifierManager {
    public static final PollinatedRegistry<ResourceModifierType> REGISTRY = PollinatedRegistry.createSimple(ResourceModifierType.class, new class_2960("pollen", "resource_modifier"));
    public static final Supplier<ResourceModifierType> ADVANCEMENT = REGISTRY.register("advancement", () -> ResourceModifierType.create(AdvancementModifier.Builder::fromJson));
    public static final Supplier<ResourceModifierType> LOOT = REGISTRY.register("loot", () -> ResourceModifierType.create(LootModifier.Builder::fromJson));
    public static final Supplier<ResourceModifierType> MODEL_OVERRIDE = REGISTRY.register("model_override", () -> ResourceModifierType.create(ModelOverrideModifier.Builder::fromJson));
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_2960, ResourceModifier<?>> DATA_MODIFIERS = new HashMap();
    private static final Map<class_2960, ResourceModifier<?>> RESOURCE_MODIFIERS = new HashMap();
    private static SidedReloader serverReloader = null;
    private static final Supplier<SidedReloader> CLIENT_RELOADER = Suppliers.memoize(() -> new SidedReloader("resource", RESOURCE_MODIFIERS, type -> (n, json, inject, priority) -> {
        if (!(type.getSerializer() instanceof ResourceModifierSerializer)) {
            throw new JsonSyntaxException(REGISTRY.getKey((ResourceModifierType)type) + " is not a resource modifier");
        }
        return ((ResourceModifierSerializer)type.getSerializer()).deserialize(n, json, inject, priority);
    }));

    private ResourceModifierManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        AdvancementConstructingEvent.EVENT.register((builder, context) -> ResourceModifierManager.getDataModifiersFor(ADVANCEMENT.get(), context.method_27795()).forEachOrdered(modifier -> {
            try {
                modifier.modify(builder);
            }
            catch (Exception e) {
                LOGGER.error("Failed to apply advancement modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
            }
        }));
        LootTableConstructingEvent.EVENT.register(context -> {
            class_2960 id = context.getId();
            ResourceModifierManager.getDataModifiersFor(LOOT.get(), id).forEachOrdered(modifier -> {
                try {
                    modifier.modify(context);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to apply loot modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
                }
            });
        });
    }

    @ApiStatus.Internal
    public static void initClient() {
        ResourceRegistry.registerReloadListener(class_3264.field_14188, CLIENT_RELOADER.get());
        ModelEvents.LOAD_BLOCK_MODEL.register((location, model) -> ResourceModifierManager.getResourceModifiersFor(MODEL_OVERRIDE.get(), location).forEachOrdered(modifier -> {
            try {
                modifier.modify(model);
            }
            catch (Exception e) {
                LOGGER.error("Failed to apply model override modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
            }
        }));
    }

    @ApiStatus.Internal
    public static class_3302 createServerReloader(class_5350 serverResources) {
        serverReloader = new SidedReloader("data", DATA_MODIFIERS, type -> (n, json, inject, priority) -> {
            if (!(type.getSerializer() instanceof DataModifierSerializer)) {
                throw new JsonSyntaxException(REGISTRY.getKey((ResourceModifierType)type) + " is not a data modifier");
            }
            return ((DataModifierSerializer)type.getSerializer()).deserialize(n, serverResources, json, inject, priority);
        });
        return serverReloader;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> getServerCompleteFuture() {
        return serverReloader.getCompleteFuture();
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> getClientCompleteFuture() {
        return CLIENT_RELOADER.get().getCompleteFuture();
    }

    @Nullable
    public static ResourceModifier<?> getDataModifier(class_2960 id) {
        return DATA_MODIFIERS.get(id);
    }

    @Nullable
    public static ResourceModifier<?> getResourceModifier(class_2960 id) {
        return RESOURCE_MODIFIERS.get(id);
    }

    public static <T> Stream<ResourceModifier<T>> getDataModifiersFor(ResourceModifierType type, class_2960 id) {
        return DATA_MODIFIERS.values().stream().filter(modifier -> modifier.getType() == type && ArrayUtils.contains((Object[])modifier.getInject(), (Object)id)).map(resourceModifier -> resourceModifier).sorted(Comparator.comparingInt(ResourceModifier::getInjectPriority).reversed());
    }

    public static <T> Stream<ResourceModifier<T>> getResourceModifiersFor(ResourceModifierType type, class_2960 id) {
        return RESOURCE_MODIFIERS.values().stream().filter(modifier -> modifier.getType() == type && ArrayUtils.contains((Object[])modifier.getInject(), (Object)id)).map(resourceModifier -> resourceModifier).sorted(Comparator.comparingInt(ResourceModifier::getInjectPriority).reversed());
    }

    private static ResourceModifier<?> deserialize(class_2960 name, JsonElement element, Function<ResourceModifierType, ResourceModifierSerializer> function) {
        class_2960[] class_2960Array;
        JsonObject json = class_3518.method_15295((JsonElement)element, (String)"modifier");
        if (!json.has("inject")) {
            throw new JsonSyntaxException("Missing inject, expected to find a String or JsonArray");
        }
        class_2960 typeName = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        ResourceModifierType type = REGISTRY.getOptional(typeName).orElseThrow(() -> new JsonSyntaxException("Unknown resource type: " + typeName));
        JsonElement injectElement = json.get("inject");
        if (!(injectElement.isJsonPrimitive() && injectElement.getAsJsonPrimitive().isString() || injectElement.isJsonArray())) {
            throw new JsonSyntaxException("Expected inject to be a String or JsonArray, was " + class_3518.method_15266((JsonElement)injectElement));
        }
        if (injectElement.isJsonPrimitive() && injectElement.getAsJsonPrimitive().isString()) {
            class_2960[] class_2960Array2 = new class_2960[1];
            class_2960Array = class_2960Array2;
            class_2960Array2[0] = new class_2960(class_3518.method_15287((JsonElement)injectElement, (String)"inject"));
        } else {
            class_2960Array = JSONTupleParser.getArray(json, "inject", new class_2960[0], 1, class_2960::new);
        }
        class_2960[] inject = class_2960Array;
        int priority = class_3518.method_15282((JsonObject)json, (String)"injectPriority", (int)1000);
        return function.apply(type).deserialize(name, json, inject, priority).build(name);
    }

    private static class SidedReloader
    implements ReloadStartListener,
    PollinatedPreparableReloadListener {
        private static final Gson GSON = new GsonBuilder().create();
        private final String type;
        private final class_3302 listener;
        private CompletableFuture<Void> completeFuture;

        private SidedReloader(final String type, final Map<class_2960, ResourceModifier<?>> resourceModifiers, final Function<ResourceModifierType, ResourceModifierSerializer> function) {
            this.type = type;
            this.listener = new class_4309(GSON, "resource_modifiers"){

                protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
                    HashMap modifiers = new HashMap();
                    map.forEach((name, element) -> {
                        try {
                            modifiers.put(name, ResourceModifierManager.deserialize(name, element, function));
                        }
                        catch (Exception e) {
                            LOGGER.error("Parsing error loading custom {} modifier {}: {}", (Object)type, name, (Object)e.getMessage());
                        }
                    });
                    resourceModifiers.clear();
                    resourceModifiers.putAll(modifiers);
                    LOGGER.info("Loaded {} {} modifiers", (Object)modifiers.size(), (Object)type);
                }
            };
            this.completeFuture = CompletableFuture.completedFuture(null);
        }

        @Override
        public void onReloadStart(class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
            this.completeFuture = this.listener.method_25931(CompletableFuture::completedFuture, resourceManager, (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, Runnable::run, gameExecutor);
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.completeFuture.thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0));
        }

        @Override
        public class_2960 getPollenId() {
            return new class_2960("pollen", this.type + "_modifiers");
        }

        public CompletableFuture<Void> getCompleteFuture() {
            return this.completeFuture;
        }
    }
}

