/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.PollinatedBlockRegistry;
import gg.moonflower.pollen.api.registry.PollinatedEntityRegistry;
import gg.moonflower.pollen.api.registry.PollinatedFluidRegistry;
import gg.moonflower.pollen.api.registry.fabric.PollinatedRegistryImpl;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_2348;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PollinatedRegistry<T>
implements Codec<T>,
Keyable,
Iterable<T> {
    protected final String modId;
    private boolean registered;

    protected PollinatedRegistry(String modId) {
        this.modId = modId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> PollinatedRegistry<T> create(class_2378<T> registry, String modId) {
        void var1_1;
        return PollinatedRegistryImpl.create(registry, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> PollinatedRegistry<T> create(PollinatedRegistry<T> registry, String modId) {
        void var1_1;
        return PollinatedRegistryImpl.create(registry, (String)var1_1);
    }

    public static PollinatedBlockRegistry createBlock(PollinatedRegistry<class_1792> itemRegistry) {
        return new PollinatedBlockRegistry(PollinatedRegistry.create(class_2378.field_11146, itemRegistry.getModId()), itemRegistry);
    }

    public static PollinatedFluidRegistry createFluid(String domain) {
        return new PollinatedFluidRegistry(PollinatedRegistry.create(class_2378.field_11154, domain));
    }

    public static PollinatedEntityRegistry createEntity(String domain) {
        return new PollinatedEntityRegistry(PollinatedRegistry.create(class_2378.field_11145, domain));
    }

    public static <T> PollinatedRegistry<T> createVanilla(class_2378<T> registry, String modId) {
        return new VanillaImpl<T>(registry, modId);
    }

    public static <T> PollinatedRegistry<T> createSimple(Class<T> type, class_2960 registryId) {
        return PollinatedRegistry.createVanilla(new class_2370(class_5321.method_29180((class_2960)registryId), Lifecycle.stable()), registryId.method_12836());
    }

    public static <T> PollinatedRegistry<T> createDefaulted(Class<T> type, class_2960 registryId, class_2960 defaultId) {
        return PollinatedRegistry.createVanilla(new class_2348(defaultId.toString(), class_5321.method_29180((class_2960)registryId), Lifecycle.stable()), registryId.method_12836());
    }

    public String getModId() {
        return this.modId;
    }

    public abstract <R extends T> Supplier<R> register(String var1, Supplier<R> var2);

    public <R extends T> Supplier<R> registerConditional(String id, Supplier<R> dummy, Supplier<R> object, boolean register) {
        return this.register(id, register ? object : dummy);
    }

    @Nullable
    public abstract class_2960 getKey(T var1);

    @Nullable
    public abstract T get(@Nullable class_2960 var1);

    public Optional<T> getOptional(@Nullable class_2960 name) {
        return Optional.ofNullable(this.get(name));
    }

    public abstract Set<class_2960> keySet();

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean containsKey(class_2960 var1);

    public final void register(Platform mod) {
        if (this.registered) {
            throw new IllegalStateException("Cannot register a PollinatedRegistry twice!");
        }
        this.registered = true;
        this.onRegister(mod);
    }

    @ApiStatus.OverrideOnly
    protected void onRegister(Platform mod) {
    }

    @ApiStatus.Internal
    public static class VanillaImpl<T>
    extends PollinatedRegistry<T> {
        private final class_2378<T> registry;
        private final Codec<T> codec;

        private VanillaImpl(class_2378<T> registry, String modId) {
            super(modId);
            this.registry = registry;
            this.codec = this.registry.method_39673();
        }

        public class_2378<T> getRegistry() {
            return this.registry;
        }

        @Override
        public <R extends T> Supplier<R> register(String id, Supplier<R> object) {
            Object registered = class_2378.method_10230(this.registry, (class_2960)new class_2960(this.modId, id), object.get());
            return () -> registered;
        }

        @Override
        @Nullable
        public class_2960 getKey(T value) {
            return this.registry.method_10221(value);
        }

        @Override
        @Nullable
        public T get(@Nullable class_2960 name) {
            return (T)this.registry.method_10223(name);
        }

        @Override
        public Set<class_2960> keySet() {
            return this.registry.method_10235();
        }

        @Override
        public boolean containsKey(class_2960 name) {
            return this.registry.method_10250(name);
        }

        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            return this.codec.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            return this.codec.encode(input, ops, prefix);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
            return this.registry.keys(ops);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }
}

