/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.serialization.Codec;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.WrapperPollinatedRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4171;
import org.jetbrains.annotations.Nullable;

public class PollinatedEntityRegistry
extends WrapperPollinatedRegistry<class_1299<?>> {
    private final PollinatedRegistry<class_4140<?>> memoryModuleTypeRegistry;
    private final PollinatedRegistry<class_4149<?>> sensorTypeRegistry;
    private final PollinatedRegistry<class_4170> scheduleRegistry;
    private final PollinatedRegistry<class_4168> activityRegistry;

    PollinatedEntityRegistry(PollinatedRegistry<class_1299<?>> entityRegistry) {
        super(entityRegistry);
        this.memoryModuleTypeRegistry = PollinatedEntityRegistry.create(class_2378.field_18793, entityRegistry.getModId());
        this.sensorTypeRegistry = PollinatedEntityRegistry.create(class_2378.field_18794, entityRegistry.getModId());
        this.scheduleRegistry = PollinatedEntityRegistry.create(class_2378.field_18795, entityRegistry.getModId());
        this.activityRegistry = PollinatedEntityRegistry.create(class_2378.field_18796, entityRegistry.getModId());
    }

    @Override
    protected void onRegister(Platform mod) {
        super.onRegister(mod);
        this.memoryModuleTypeRegistry.onRegister(mod);
        this.sensorTypeRegistry.onRegister(mod);
        this.scheduleRegistry.onRegister(mod);
        this.activityRegistry.onRegister(mod);
    }

    public <R> Supplier<class_4140<R>> registerMemoryModuleType(String id) {
        return this.registerMemoryModuleType(id, null);
    }

    public <R> Supplier<class_4140<R>> registerMemoryModuleType(String id, @Nullable Codec<R> codec) {
        return this.memoryModuleTypeRegistry.register(id, () -> new class_4140(Optional.ofNullable(codec)));
    }

    public <R extends class_4148<?>> Supplier<class_4149<R>> registerSensorType(String id, Supplier<R> supplier) {
        return this.sensorTypeRegistry.register(id, () -> new class_4149(supplier));
    }

    public Supplier<class_4170> registerSchedule(String id, Consumer<class_4171> builder) {
        return this.scheduleRegistry.register(id, () -> {
            class_4170 schedule = new class_4170();
            builder.accept(new class_4171(schedule));
            return schedule;
        });
    }

    public Supplier<class_4168> registerActivity(String id) {
        return this.activityRegistry.register(id, () -> new class_4168(this.activityRegistry.getModId() + ":" + id));
    }

    public PollinatedRegistry<class_4140<?>> getMemoryModuleTypeRegistry() {
        return this.memoryModuleTypeRegistry;
    }

    public PollinatedRegistry<class_4149<?>> getSensorTypeRegistry() {
        return this.sensorTypeRegistry;
    }

    public PollinatedRegistry<class_4170> getScheduleRegistry() {
        return this.scheduleRegistry;
    }

    public PollinatedRegistry<class_4168> getActivityRegistry() {
        return this.activityRegistry;
    }
}

