/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.platform.fabric;

import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.api.util.fabric.PollinatedModContainerImpl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2403;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FabricPlatform
extends Platform {
    private final Runnable commonInit;
    private final Runnable clientInit;
    private final Consumer<Platform.ModSetupContext> commonPostInit;
    private final Consumer<Platform.ModSetupContext> clientPostInit;
    private final Consumer<Platform.DataSetupContext> dataInit;

    FabricPlatform(String modId, Runnable commonInit, Runnable clientInit, Consumer<Platform.ModSetupContext> commonPostInit, Consumer<Platform.ModSetupContext> clientPostInit, Consumer<Platform.DataSetupContext> dataInit) {
        super(modId);
        this.commonInit = commonInit;
        this.clientInit = clientInit;
        this.commonPostInit = commonPostInit;
        this.clientPostInit = clientPostInit;
        this.dataInit = dataInit;
    }

    @Override
    public void setup() {
        ModSetupContextImpl context = new ModSetupContextImpl();
        this.commonInit.run();
        this.commonPostInit.accept(context);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.clientInit.run();
            this.clientPostInit.accept(context);
        }
    }

    @Override
    public void dataSetup(class_2403 dataGenerator) {
        this.dataInit.accept(new DataSetupContextImpl((FabricDataGenerator)dataGenerator));
    }

    private static class ModSetupContextImpl
    implements Platform.ModSetupContext {
        private ModSetupContextImpl() {
        }

        @Override
        public CompletableFuture<Void> enqueueWork(Runnable work) {
            work.run();
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public <T> CompletableFuture<T> enqueueWork(Supplier<T> work) {
            return CompletableFuture.completedFuture(work.get());
        }
    }

    private static class DataSetupContextImpl
    implements Platform.DataSetupContext {
        private final FabricDataGenerator generator;

        private DataSetupContextImpl(FabricDataGenerator generator) {
            this.generator = generator;
        }

        @Override
        public class_2403 getGenerator() {
            return this.generator;
        }

        @Override
        public PollinatedModContainer getMod() {
            return new PollinatedModContainerImpl(this.generator.getModContainer());
        }
    }
}

