/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.fabric;

import com.google.common.base.Suppliers;
import gg.moonflower.pollen.api.network.PacketDeserializer;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedNetworkChannelImpl {
    protected final class_2960 channelId;
    protected final List<PacketFactory<?, ?>> factories;
    protected final Supplier<Object> clientMessageHandler;
    protected final Supplier<Object> serverMessageHandler;

    protected PollinatedNetworkChannelImpl(class_2960 channelId, Supplier<Object> clientFactory, Supplier<Object> serverFactory) {
        this.channelId = channelId;
        this.factories = new ArrayList();
        this.clientMessageHandler = Suppliers.memoize(clientFactory::get);
        this.serverMessageHandler = Suppliers.memoize(serverFactory::get);
    }

    protected class_2540 serialize(PollinatedPacket<?> message, PollinatedPacketDirection expectedDirection) {
        Optional<PacketFactory> factoryOptional = this.factories.stream().filter(factory -> factory.clazz == message.getClass()).findFirst();
        if (factoryOptional.isEmpty()) {
            throw new IllegalStateException("Unregistered packet: " + message.getClass() + " on channel: " + this.channelId);
        }
        int id = this.factories.indexOf(factoryOptional.get());
        if (factoryOptional.get().direction != null && factoryOptional.get().direction != expectedDirection) {
            throw new IllegalStateException("Attempted to send packet with id: " + id + ". Expected " + expectedDirection + ", got " + factoryOptional.get().direction);
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(id);
        try {
            message.writePacketData(buf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write packet data", e);
        }
        return buf;
    }

    protected PollinatedPacket<?> deserialize(class_2540 buf, PollinatedPacketDirection expectedDirection) {
        int id = buf.method_10816();
        if (id < 0 || id >= this.factories.size()) {
            throw new IllegalStateException("Unknown packet with id: " + id);
        }
        PacketFactory<?, ?> factory = this.factories.get(id);
        if (factory.direction != null && factory.direction != expectedDirection) {
            throw new IllegalStateException("Received unexpected packet with id: " + id + ". Expected " + expectedDirection + ", got " + factory.direction);
        }
        try {
            return factory.deserializer.deserialize(buf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read packet data", e);
        }
    }

    protected <MSG extends PollinatedPacket<T>, T> void register(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, @Nullable PollinatedPacketDirection direction) {
        this.factories.add(new PacketFactory<MSG, T>(clazz, deserializer, direction));
    }

    private record PacketFactory<MSG extends PollinatedPacket<T>, T>(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, PollinatedPacketDirection direction) {
    }
}

