/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.fabric;

import gg.moonflower.pollen.api.network.PacketDeserializer;
import gg.moonflower.pollen.api.network.PollinatedPlayNetworkChannel;
import gg.moonflower.pollen.api.network.fabric.PollinatedNetworkChannelImpl;
import gg.moonflower.pollen.api.network.fabric.context.PollinatedFabricPlayPacketContext;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import gg.moonflower.pollen.api.registry.NetworkRegistry;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedFabricPlayChannel
extends PollinatedNetworkChannelImpl
implements PollinatedPlayNetworkChannel {
    public PollinatedFabricPlayChannel(class_2960 channelId, Supplier<Object> clientFactory, Supplier<Object> serverFactory) {
        super(channelId, clientFactory, serverFactory);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channelId, this::processClientPlay);
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.channelId, this::processServerPlay);
    }

    private void processClientPlay(class_310 client, class_634 listener, class_2540 data, PacketSender responseSender) {
        NetworkRegistry.processMessage(this.deserialize(data, PollinatedPacketDirection.PLAY_CLIENTBOUND), new PollinatedFabricPlayPacketContext(listener.method_2872(), pkt -> responseSender.sendPacket(responseSender.createPacket(this.channelId, this.serialize((PollinatedPacket<?>)pkt, PollinatedPacketDirection.PLAY_SERVERBOUND))), PollinatedPacketDirection.PLAY_CLIENTBOUND), this.clientMessageHandler);
    }

    private void processServerPlay(MinecraftServer server, class_3222 player, class_3244 listener, class_2540 data, PacketSender responseSender) {
        NetworkRegistry.processMessage(this.deserialize(data, PollinatedPacketDirection.PLAY_SERVERBOUND), new PollinatedFabricPlayPacketContext(listener.method_2872(), pkt -> responseSender.sendPacket(responseSender.createPacket(this.channelId, this.serialize((PollinatedPacket<?>)pkt, PollinatedPacketDirection.PLAY_CLIENTBOUND))), PollinatedPacketDirection.PLAY_SERVERBOUND), this.serverMessageHandler);
    }

    @Override
    public void sendTo(class_3222 player, PollinatedPacket<?> packet) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND));
    }

    @Override
    public void sendTo(class_3218 level, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.world((class_3218)level)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToNear(class_3218 level, double x, double y, double z, double radius, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.around((class_3218)level, (class_243)new class_243(x, y, z), (double)radius)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToAll(MinecraftServer server, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToTracking(class_1297 entity, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToTracking(class_3218 level, class_2338 pos, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToTracking(class_3218 level, class_1923 pos, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_1923)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToTrackingAndSelf(class_1297 entity, PollinatedPacket<?> packet) {
        class_2540 data = this.serialize(packet, PollinatedPacketDirection.PLAY_CLIENTBOUND);
        if (entity instanceof class_3222) {
            ServerPlayNetworking.send((class_3222)((class_3222)entity), (class_2960)this.channelId, (class_2540)data);
        }
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)data);
        }
    }

    @Override
    public void sendToServer(PollinatedPacket<?> packet) {
        ClientPlayNetworking.send((class_2960)this.channelId, (class_2540)this.serialize(packet, PollinatedPacketDirection.PLAY_SERVERBOUND));
    }

    @Override
    public class_2596<?> toVanillaPacket(PollinatedPacket<?> packet, PollinatedPacketDirection direction) {
        switch (direction) {
            case PLAY_SERVERBOUND: {
                return new class_2817(this.channelId, this.serialize(packet, direction));
            }
            case PLAY_CLIENTBOUND: {
                return new class_2658(this.channelId, this.serialize(packet, direction));
            }
        }
        throw new IllegalStateException("Unsupported packet direction: " + direction);
    }

    @Override
    public <MSG extends PollinatedPacket<T>, T> void register(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, @Nullable PollinatedPacketDirection direction) {
        super.register(clazz, deserializer, direction);
    }
}

