/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.fabric;

import gg.moonflower.pollen.api.network.PacketDeserializer;
import gg.moonflower.pollen.api.network.PollinatedLoginNetworkChannel;
import gg.moonflower.pollen.api.network.fabric.PollinatedNetworkChannelImpl;
import gg.moonflower.pollen.api.network.fabric.context.PollinatedFabricLoginPacketContext;
import gg.moonflower.pollen.api.network.fabric.context.PollinatedFabricPacketContext;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import gg.moonflower.pollen.api.network.packet.login.PollinatedLoginPacket;
import gg.moonflower.pollen.api.registry.NetworkRegistry;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3248;
import net.minecraft.class_635;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedFabricLoginChannel
extends PollinatedNetworkChannelImpl
implements PollinatedLoginNetworkChannel {
    private final List<Function<Boolean, ? extends List<? extends Pair<String, ?>>>> loginPackets = new ArrayList();

    public PollinatedFabricLoginChannel(class_2960 channelId, Supplier<Object> clientFactory, Supplier<Object> serverFactory) {
        super(channelId, clientFactory, serverFactory);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientLoginNetworking.registerGlobalReceiver((class_2960)this.channelId, this::processClient);
        }
        ServerLoginNetworking.registerGlobalReceiver((class_2960)this.channelId, this::processServer);
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> this.loginPackets.stream().flatMap(function -> ((List)function.apply(handler.method_2872().method_10756())).stream()).forEach(pair -> sender.sendPacket(sender.createPacket(this.channelId, this.serialize((PollinatedPacket)pair.getValue(), PollinatedPacketDirection.LOGIN_CLIENTBOUND)))));
    }

    private CompletableFuture<@Nullable class_2540> processClient(class_310 client, class_635 listener, class_2540 data, Consumer<GenericFutureListener<? extends Future<? super Void>>> listenerAdder) {
        CompletableFuture<class_2540> future = new CompletableFuture<class_2540>();
        NetworkRegistry.processMessage(this.deserialize(data, PollinatedPacketDirection.LOGIN_CLIENTBOUND), new PollinatedFabricLoginPacketContext(pkt -> {
            try {
                future.complete(this.serialize((PollinatedPacket<?>)pkt, PollinatedPacketDirection.LOGIN_SERVERBOUND));
            }
            catch (Throwable t) {
                t.printStackTrace();
                future.completeExceptionally(t);
            }
        }, listener.method_2872(), __ -> {}, PollinatedPacketDirection.LOGIN_CLIENTBOUND), this.clientMessageHandler);
        return future;
    }

    private void processServer(MinecraftServer server, class_3248 listener, boolean understood, class_2540 data, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender responseSender) {
        if (!understood) {
            throw new IllegalStateException("Client failed to process server message");
        }
        NetworkRegistry.processMessage(this.deserialize(data, PollinatedPacketDirection.LOGIN_SERVERBOUND), new PollinatedFabricPacketContext(listener.method_2872(), synchronizer, PollinatedPacketDirection.LOGIN_SERVERBOUND){

            @Override
            public void reply(PollinatedPacket<?> packet) {
                throw new UnsupportedOperationException("The server is not allowed to reply during the login phase.");
            }
        }, this.serverMessageHandler);
    }

    @Override
    public <MSG extends PollinatedLoginPacket<T>, T> void register(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer) {
        super.register(clazz, deserializer, PollinatedPacketDirection.LOGIN_SERVERBOUND);
    }

    @Override
    public <MSG extends PollinatedLoginPacket<T>, T> void registerLogin(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, Function<Boolean, List<Pair<String, MSG>>> loginPacketGenerators) {
        super.register(clazz, deserializer, PollinatedPacketDirection.LOGIN_CLIENTBOUND);
        this.loginPackets.add(loginPacketGenerators);
    }

    @Override
    public class_2596<?> toVanillaPacket(PollinatedPacket<?> packet, int transactionId, PollinatedPacketDirection direction) {
        return switch (direction) {
            case PollinatedPacketDirection.LOGIN_SERVERBOUND -> new class_2913(transactionId, this.serialize(packet, direction));
            case PollinatedPacketDirection.LOGIN_CLIENTBOUND -> new class_2899(transactionId, this.channelId, this.serialize(packet, direction));
            default -> throw new IllegalStateException("Unsupported packet direction: " + direction);
        };
    }
}

