/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.event.events;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.event.PollinatedEvent;
import gg.moonflower.pollen.api.event.events.fabric.LootTableConstructingEventImpl;
import gg.moonflower.pollen.api.registry.EventRegistry;
import gg.moonflower.pollen.core.mixin.loot.LootPoolAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootPoolBuilderAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableBuilderAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_117;
import net.minecraft.class_176;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_79;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface LootTableConstructingEvent {
    public static final PollinatedEvent<LootTableConstructingEvent> EVENT = EventRegistry.create(LootTableConstructingEvent.class, events -> context -> {
        for (LootTableConstructingEvent event : events) {
            event.modifyLootTable(context);
        }
    });

    public void modifyLootTable(Context var1);

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<class_55> getPools(class_52 lootTable) {
        return LootTableConstructingEventImpl.getPools(lootTable);
    }

    public static class Context {
        private final class_52 source;
        private final class_2960 loadingId;
        private final class_52.class_53 builder;
        private final Map<Integer, LootPoolModifier> modifyPools;
        private final Set<Integer> removePools;
        private final Set<Integer> removeFunctions;
        private boolean changed;

        public Context(class_2960 loadingId, class_52 source) {
            this.loadingId = loadingId;
            this.source = source;
            this.builder = class_52.method_324().method_334(source.method_322());
            this.modifyPools = new HashMap<Integer, LootPoolModifier>();
            this.removePools = new HashSet<Integer>();
            this.removeFunctions = new HashSet<Integer>();
            ((LootTableBuilderAccessor)this.builder).getPools().addAll(LootTableConstructingEvent.getPools(source));
            ((LootTableBuilderAccessor)this.builder).getFunctions().addAll(Arrays.asList(((LootTableAccessor)source).getFunctions()));
        }

        private void updatePool(int index, Consumer<class_55.class_56> action) {
            List<class_55> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            LootPoolAccessor sourceAccessor = (LootPoolAccessor)pools.get(index);
            class_55.class_56 builder = class_55.method_347().method_352(sourceAccessor.getRolls());
            LootPoolBuilderAccessor accessor = (LootPoolBuilderAccessor)builder;
            accessor.getEntries().addAll(Arrays.asList(sourceAccessor.getEntries()));
            accessor.getConditions().addAll(Arrays.asList(sourceAccessor.getConditions()));
            accessor.getFunctions().addAll(Arrays.asList(sourceAccessor.getFunctions()));
            accessor.setBonusRolls(sourceAccessor.getBonusRolls());
            action.accept(builder);
            pools.set(index, builder.method_355());
            this.changed = true;
        }

        private void removeFromPool(int index, Consumer<LootPoolModifier> action) {
            List<class_55> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            action.accept(this.modifyPools.computeIfAbsent(index, __ -> new LootPoolModifier()));
            this.changed = true;
        }

        @ApiStatus.Internal
        public class_52 apply() {
            int j;
            if (!this.changed) {
                return this.source;
            }
            this.modifyPools.keySet().removeIf(this.removePools::contains);
            List<class_55> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            List<class_117> functions = ((LootTableBuilderAccessor)this.builder).getFunctions();
            for (Map.Entry<Integer, LootPoolModifier> entry : this.modifyPools.entrySet()) {
                int j2;
                int index = entry.getKey();
                if (index < 0 || index >= pools.size()) continue;
                class_55 pool = pools.get(index);
                class_55.class_56 poolBuilder = class_55.method_347();
                LootPoolAccessor poolAccessor = (LootPoolAccessor)pool;
                LootPoolBuilderAccessor builderAccessor = (LootPoolBuilderAccessor)poolBuilder;
                LootPoolModifier modifier = entry.getValue();
                builderAccessor.getEntries().addAll(Arrays.asList(poolAccessor.getEntries()));
                builderAccessor.getConditions().addAll(Arrays.asList(poolAccessor.getConditions()));
                builderAccessor.getFunctions().addAll(Arrays.asList(poolAccessor.getFunctions()));
                int[] removeEntriesArray = modifier.removeEntries.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeConditionsArray = modifier.removeConditions.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeFunctionsArray = modifier.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
                for (j2 = 0; j2 < removeEntriesArray.length; ++j2) {
                    builderAccessor.getEntries().remove(removeEntriesArray[removeEntriesArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeConditionsArray.length; ++j2) {
                    builderAccessor.getConditions().remove(removeConditionsArray[removeConditionsArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeFunctionsArray.length; ++j2) {
                    builderAccessor.getFunctions().remove(removeFunctionsArray[removeFunctionsArray.length - j2 - 1]);
                }
                pools.set(index, poolBuilder.method_355());
            }
            int[] removePoolsArray = this.removePools.stream().mapToInt(i -> i).sorted().toArray();
            int[] removeFunctionsArray = this.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
            for (j = 0; j < removePoolsArray.length; ++j) {
                pools.remove(removePoolsArray[removePoolsArray.length - j - 1]);
            }
            for (j = 0; j < removeFunctionsArray.length; ++j) {
                functions.remove(removeFunctionsArray[removeFunctionsArray.length - j - 1]);
            }
            this.modifyPools.clear();
            this.removePools.clear();
            this.removeFunctions.clear();
            return this.builder.method_338();
        }

        public void addPool(class_55 lootPool) {
            ((LootTableBuilderAccessor)this.builder).getPools().add(lootPool);
            this.changed = true;
        }

        public void addPool(class_55.class_56 lootPool) {
            this.builder.method_336(lootPool);
            this.changed = true;
        }

        public void addFunction(class_117 function) {
            ((LootTableBuilderAccessor)this.builder).getFunctions().add(function);
            this.changed = true;
        }

        public void addFunction(class_117.class_118 function) {
            this.builder.method_335(function);
            this.changed = true;
        }

        public void setParamSet(class_176 parameterSet) {
            this.builder.method_334(parameterSet);
            this.changed = true;
        }

        public void insertPool(int poolIndex, class_55 ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (class_55 injectPool : pools) {
                    LootPoolAccessor injectPoolAccessor = (LootPoolAccessor)injectPool;
                    poolAccessor.getEntries().addAll(Arrays.asList(injectPoolAccessor.getEntries()));
                    poolAccessor.getConditions().addAll(Arrays.asList(injectPoolAccessor.getConditions()));
                    poolAccessor.getFunctions().addAll(Arrays.asList(injectPoolAccessor.getFunctions()));
                }
            });
        }

        public void insertPool(int poolIndex, class_55.class_56 ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (class_55.class_56 injectPool : pools) {
                    LootPoolBuilderAccessor injectPoolAccessor = (LootPoolBuilderAccessor)injectPool;
                    poolAccessor.getEntries().addAll(injectPoolAccessor.getEntries());
                    poolAccessor.getConditions().addAll(injectPoolAccessor.getConditions());
                    poolAccessor.getFunctions().addAll(injectPoolAccessor.getFunctions());
                }
            });
        }

        public void insertEntry(int poolIndex, class_79 ... entries) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getEntries().addAll(Arrays.asList(entries)));
        }

        public void insertEntry(int poolIndex, class_79.class_80<?> ... entries) {
            this.updatePool(poolIndex, pool -> {
                for (class_79.class_80 entry : entries) {
                    pool.method_351(entry);
                }
            });
        }

        public void insertCondition(int poolIndex, class_5341 ... conditions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getConditions().addAll(Arrays.asList(conditions)));
        }

        public void insertCondition(int poolIndex, class_5341.class_210 ... conditions) {
            this.updatePool(poolIndex, pool -> {
                for (class_5341.class_210 condition : conditions) {
                    pool.method_356(condition);
                }
            });
        }

        public void insertFunction(int poolIndex, class_117 ... functions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getFunctions().addAll(Arrays.asList(functions)));
        }

        public void insertFunction(int poolIndex, class_117.class_118 ... functions) {
            this.updatePool(poolIndex, pool -> {
                for (class_117.class_118 function : functions) {
                    pool.method_353(function);
                }
            });
        }

        public void removeEntry(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeEntries.add(index));
        }

        public void removeCondition(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeConditions.add(index));
        }

        public void removeFunction(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeFunctions.add(index));
        }

        public void removePool(int index) {
            this.removePools.add(index);
            this.changed = true;
        }

        public void removeFunction(int index) {
            this.removeFunctions.add(index);
            this.changed = true;
        }

        public class_2960 getId() {
            return this.loadingId;
        }

        public class_52 getLootTable() {
            return this.source;
        }

        private static class LootPoolModifier {
            private final Set<Integer> removeEntries = new HashSet<Integer>();
            private final Set<Integer> removeConditions = new HashSet<Integer>();
            private final Set<Integer> removeFunctions = new HashSet<Integer>();

            private LootPoolModifier() {
            }
        }
    }
}

