/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.tags;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.ConditionalDataProvider;
import gg.moonflower.pollen.api.resource.condition.ConditionalTagEntry;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.extensions.TagBuilderExtension;
import gg.moonflower.pollen.core.mixin.data.TagsProviderAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5321;

public abstract class PollinatedTagsProvider<T>
extends class_2474<T>
implements ConditionalDataProvider {
    private final Map<class_2960, List<PollinatedResourceConditionProvider>> providers = new HashMap<class_2960, List<PollinatedResourceConditionProvider>>();
    private final String domain;

    public PollinatedTagsProvider(class_2403 generator, PollinatedModContainer container, class_2378<T> registry) {
        super(generator, registry);
        this.domain = container.getId();
    }

    public void addConditions(class_3494.class_5123<T> tag, PollinatedResourceConditionProvider ... providers) {
        this.addConditions(tag.method_26791(), providers);
    }

    @Override
    public void addConditions(class_2960 id, PollinatedResourceConditionProvider ... providers) {
        if (providers.length == 0) {
            return;
        }
        this.providers.computeIfAbsent(id, __ -> new ArrayList()).addAll(Arrays.asList(providers));
    }

    @Override
    public void injectConditions(class_2960 id, JsonObject json) {
        if (this.providers.containsKey(id)) {
            PollinatedResourceConditionProvider.write(json, this.providers.get(id).toArray(new PollinatedResourceConditionProvider[0]));
        }
    }

    protected PollinatedTagAppender<T> tag(class_3494.class_5123<T> tag) {
        return new PollinatedTagAppender(this.method_27169(tag), this.field_11482, this.domain);
    }

    protected class_3494.class_3495 method_27169(class_3494.class_5123<T> tag) {
        return ((TagsProviderAccessor)((Object)this)).getBuilders().computeIfAbsent(tag.method_26791(), __ -> new class_3494.class_3495());
    }

    public static class PollinatedTagAppender<T>
    extends class_2474.class_5124<T> {
        private final class_3494.class_3495 builder;
        private final class_2378<T> registry;
        private final String source;

        protected PollinatedTagAppender(class_3494.class_3495 builder, class_2378<T> registry, String source) {
            super(builder, registry, source);
            this.builder = builder;
            this.registry = registry;
            this.source = source;
        }

        public PollinatedTagAppender<T> add(T item) {
            return (PollinatedTagAppender)super.method_26793(item);
        }

        public PollinatedTagAppender<T> addTag(class_3494.class_5123<T> tag) {
            return (PollinatedTagAppender)super.method_26792(tag);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> pollenAdd(T ... toAdd) {
            return (PollinatedTagAppender)super.method_26795((Object[])toAdd);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> addTag(class_3494.class_5123<T> ... values) {
            for (class_3494.class_5123<T> value : values) {
                this.addTag(value);
            }
            return this;
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> add(class_5321<T> ... keys) {
            for (class_5321<T> key : keys) {
                this.builder.method_26784(key.method_29177(), this.source);
            }
            return this;
        }

        public PollinatedTagAppender<T> addOptional(class_2960 resourceLocation) {
            return (PollinatedTagAppender)super.method_35922(resourceLocation);
        }

        public PollinatedTagAppender<T> addOptionalTag(class_2960 resourceLocation) {
            return (PollinatedTagAppender)super.method_35923(resourceLocation);
        }

        public PollinatedTagAppender<T> replace() {
            return this.replace(true);
        }

        public PollinatedTagAppender<T> replace(boolean value) {
            ((TagBuilderExtension)this.builder).pollen_replace(value);
            return this;
        }

        private static JsonObject createConditionJson(PollinatedResourceConditionProvider[] conditions) {
            JsonObject json = new JsonObject();
            PollinatedResourceConditionProvider.write(json, conditions);
            return json;
        }

        public PollinatedTagAppender<T> addConditional(T item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.add(item);
            }
            this.builder.method_27065((class_3494.class_3496)new ConditionalTagEntry((class_3494.class_3496)new class_3494.class_5122(this.registry.method_10221(item)), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalTag(class_3494.class_5123<T> tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addTag(tag);
            }
            this.builder.method_27065((class_3494.class_3496)new ConditionalTagEntry((class_3494.class_3496)new class_3494.class_3497(tag.method_26791()), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptional(class_2960 item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptional(item);
            }
            this.builder.method_27065((class_3494.class_3496)new ConditionalTagEntry((class_3494.class_3496)new class_3494.class_5479(item), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptionalTag(class_2960 tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptionalTag(tag);
            }
            this.builder.method_27065((class_3494.class_3496)new ConditionalTagEntry((class_3494.class_3496)new class_3494.class_5480(tag), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }
    }
}

