/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.model;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.model.PollinatedModelGenerator;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollinatedModelProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Set<ModelGeneratorFactory> factories = new HashSet<ModelGeneratorFactory>();
    private final class_2403 generator;
    private final String domain;

    public PollinatedModelProvider(class_2403 generator, PollinatedModContainer container) {
        this.generator = generator;
        this.domain = container.getId();
    }

    public PollinatedModelProvider addGenerator(ModelGeneratorFactory factory) {
        this.factories.add(factory);
        return this;
    }

    public void method_10319(class_2408 cache) {
        Path path = this.generator.method_10313();
        HashMap blockStates = new HashMap();
        Consumer<class_4917> blockStateOutput = blockStateGenerator -> {
            class_2248 block = blockStateGenerator.method_25743();
            class_4917 blockState = blockStates.put(block, blockStateGenerator);
            if (blockState != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = new HashSet();
        BiConsumer<class_2960, Supplier> modelOutput = (resourceLocation, supplier) -> {
            Supplier model = models.put(resourceLocation, supplier);
            if (model != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        Consumer<class_1792> skippedAutoModelsOutput = skippedAutoModels::add;
        this.factories.stream().map(factory -> factory.create(blockStateOutput, modelOutput, skippedAutoModelsOutput)).forEach(PollinatedModelGenerator::run);
        class_2378.field_11146.forEach(block -> {
            if (!this.domain.equals(class_2378.field_11146.method_10221(block).method_12836())) {
                return;
            }
            class_1792 item = (class_1792)class_1792.field_8003.get(block);
            if (item != null) {
                if (skippedAutoModels.contains(item)) {
                    return;
                }
                class_2960 itemLocation = class_4941.method_25840((class_1792)item);
                if (!models.containsKey(itemLocation)) {
                    models.put(itemLocation, new class_4940(class_4941.method_25842((class_2248)block)));
                }
            }
        });
        this.saveCollection(cache, path, blockStates, PollinatedModelProvider::createBlockStatePath);
        this.saveCollection(cache, path, models, PollinatedModelProvider::createModelPath);
    }

    private <T> void saveCollection(class_2408 cache, Path rootPath, Map<T, ? extends Supplier<JsonElement>> objectToJsonMap, BiFunction<Path, T, Path> resolveObjectPath) {
        objectToJsonMap.forEach((object, supplier) -> {
            Path path = (Path)resolveObjectPath.apply(rootPath, object);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)supplier.get()), (Path)path);
            }
            catch (Exception var7) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)var7);
            }
        });
    }

    private static Path createBlockStatePath(Path rootPath, class_2248 block) {
        class_2960 resourceLocation = class_2378.field_11146.method_10221((Object)block);
        return rootPath.resolve("assets/" + resourceLocation.method_12836() + "/blockstates/" + resourceLocation.method_12832() + ".json");
    }

    private static Path createModelPath(Path rootPath, class_2960 modelLocation) {
        return rootPath.resolve("assets/" + modelLocation.method_12836() + "/models/" + modelLocation.method_12832() + ".json");
    }

    public String method_10321() {
        return "Block State Definitions";
    }

    @FunctionalInterface
    public static interface ModelGeneratorFactory {
        public PollinatedModelGenerator create(Consumer<class_4917> var1, BiConsumer<class_2960, Supplier<JsonElement>> var2, Consumer<class_1792> var3);
    }
}

