/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.SimpleConditionalDataProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2037;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3957;
import net.minecraft.class_4559;
import net.minecraft.class_5377;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedRecipeProvider
extends SimpleConditionalDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;

    public PollinatedRecipeProvider(class_2403 generator) {
        this.generator = generator;
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.generator.method_10313();
        HashSet set = new HashSet();
        this.buildRecipes(finishedRecipe -> {
            if (!set.add(finishedRecipe.method_10417())) {
                throw new IllegalStateException("Duplicate recipe " + finishedRecipe.method_10417());
            }
            try {
                JsonObject json = finishedRecipe.method_17799();
                this.injectConditions(finishedRecipe.method_10417(), json);
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)json, (Path)path.resolve("data/" + finishedRecipe.method_10417().method_12836() + "/recipes/" + finishedRecipe.method_10417().method_12832() + ".json"));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)e);
            }
            JsonObject jsonObject = finishedRecipe.method_10415();
            if (jsonObject != null) {
                try {
                    this.injectConditions(finishedRecipe.method_10417(), jsonObject);
                    class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)jsonObject, (Path)path.resolve("data/" + finishedRecipe.method_10417().method_12836() + "/advancements/" + finishedRecipe.method_10418().method_12832() + ".json"));
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
                }
            }
        });
    }

    protected abstract void buildRecipes(Consumer<class_2444> var1);

    public static void netheriteSmithing(Consumer<class_2444> finishedRecipeConsumer, class_1792 ingredientItem, class_1792 resultItem) {
        class_5377.method_29729((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{ingredientItem}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), (class_1792)resultItem).method_29730("has_netherite_ingot", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_22020)).method_29731(finishedRecipeConsumer, class_2378.field_11142.method_10221((Object)resultItem.method_8389()).method_12832() + "_smithing");
    }

    public static void planksFromLog(Consumer<class_2444> finishedRecipeConsumer, class_1935 planks, class_3494<class_1792> log) {
        class_2450.method_10448((class_1935)planks, (int)4).method_10446(log).method_10452("planks").method_10442("has_log", (class_184)PollinatedRecipeProvider.has(log)).method_10431(finishedRecipeConsumer);
    }

    public static void planksFromLogs(Consumer<class_2444> finishedRecipeConsumer, class_1935 planks, class_3494<class_1792> logs) {
        class_2450.method_10448((class_1935)planks, (int)4).method_10446(logs).method_10452("planks").method_10442("has_logs", (class_184)PollinatedRecipeProvider.has(logs)).method_10431(finishedRecipeConsumer);
    }

    public static void woodFromLogs(Consumer<class_2444> finishedRecipeConsumer, class_1935 wood, class_1935 log) {
        class_2447.method_10436((class_1935)wood, (int)3).method_10434(Character.valueOf('#'), log).method_10439("##").method_10439("##").method_10435("bark").method_10429("has_log", (class_184)PollinatedRecipeProvider.has(log)).method_10431(finishedRecipeConsumer);
    }

    public static void woodenBoat(Consumer<class_2444> finishedRecipeConsumer, class_1935 boat, class_1935 material) {
        class_2447.method_10437((class_1935)boat).method_10434(Character.valueOf('#'), material).method_10439("# #").method_10439("###").method_10435("boat").method_10429("in_water", (class_184)PollinatedRecipeProvider.insideOf(class_2246.field_10382)).method_10431(finishedRecipeConsumer);
    }

    public static void woodenButton(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2450.method_10447((class_1935)itemLike).method_10454(itemLike2).method_10452("wooden_button").method_10442("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenDoor(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10436((class_1935)itemLike, (int)3).method_10434(Character.valueOf('#'), itemLike2).method_10439("##").method_10439("##").method_10439("##").method_10435("wooden_door").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenFence(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10436((class_1935)itemLike, (int)3).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8600).method_10434(Character.valueOf('W'), itemLike2).method_10439("W#W").method_10439("W#W").method_10435("wooden_fence").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenFenceGate(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10437((class_1935)itemLike).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8600).method_10434(Character.valueOf('W'), itemLike2).method_10439("#W#").method_10439("#W#").method_10435("wooden_fence_gate").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenPressurePlate(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10437((class_1935)itemLike).method_10434(Character.valueOf('#'), itemLike2).method_10439("##").method_10435("wooden_pressure_plate").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenSlab(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10436((class_1935)itemLike, (int)6).method_10434(Character.valueOf('#'), itemLike2).method_10439("###").method_10435("wooden_slab").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenStairs(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10436((class_1935)itemLike, (int)4).method_10434(Character.valueOf('#'), itemLike2).method_10439("#  ").method_10439("## ").method_10439("###").method_10435("wooden_stairs").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenTrapdoor(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        class_2447.method_10436((class_1935)itemLike, (int)2).method_10434(Character.valueOf('#'), itemLike2).method_10439("###").method_10439("###").method_10435("wooden_trapdoor").method_10429("has_planks", (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void woodenSign(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        String string = class_2378.field_11142.method_10221((Object)itemLike2.method_8389()).method_12832();
        class_2447.method_10436((class_1935)itemLike, (int)3).method_10435("sign").method_10434(Character.valueOf('#'), itemLike2).method_10434(Character.valueOf('X'), (class_1935)class_1802.field_8600).method_10439("###").method_10439("###").method_10439(" X ").method_10429("has_" + string, (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 dyedWool, class_1935 dye) {
        class_2450.method_10447((class_1935)dyedWool).method_10454(dye).method_10454((class_1935)class_2246.field_10446).method_10452("wool").method_10442("has_white_wool", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10446)).method_10431(finishedRecipeConsumer);
    }

    public static void carpetFromWool(Consumer<class_2444> consumer, class_1935 itemLike, class_1935 itemLike2) {
        String string = class_2378.field_11142.method_10221((Object)itemLike2.method_8389()).method_12832();
        class_2447.method_10436((class_1935)itemLike, (int)3).method_10434(Character.valueOf('#'), itemLike2).method_10439("##").method_10435("carpet").method_10429("has_" + string, (class_184)PollinatedRecipeProvider.has(itemLike2)).method_10431(consumer);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 dyedCarpet, class_1935 dye) {
        String string = class_2378.field_11142.method_10221((Object)dyedCarpet.method_8389()).method_12832();
        String string2 = class_2378.field_11142.method_10221((Object)dye.method_8389()).method_12832();
        class_2447.method_10436((class_1935)dyedCarpet, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10466).method_10434(Character.valueOf('$'), dye).method_10439("###").method_10439("#$#").method_10439("###").method_10435("carpet").method_10429("has_white_carpet", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10466)).method_10429("has_" + string2, (class_184)PollinatedRecipeProvider.has(dye)).method_36443(finishedRecipeConsumer, string + "_from_white_carpet");
    }

    public static void bedFromPlanksAndWool(Consumer<class_2444> finishedRecipeConsumer, class_1935 bed, class_1935 wool) {
        String string = class_2378.field_11142.method_10221((Object)wool.method_8389()).method_12832();
        class_2447.method_10437((class_1935)bed).method_10434(Character.valueOf('#'), wool).method_10433(Character.valueOf('X'), (class_3494)class_3489.field_15537).method_10439("###").method_10439("XXX").method_10435("bed").method_10429("has_" + string, (class_184)PollinatedRecipeProvider.has(wool)).method_10431(finishedRecipeConsumer);
    }

    public static void bedFromWhiteBedAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 dyedBed, class_1935 dye) {
        String string = class_2378.field_11142.method_10221((Object)dyedBed.method_8389()).method_12832();
        class_2450.method_10447((class_1935)dyedBed).method_10454((class_1935)class_1802.field_8258).method_10454(dye).method_10452("dyed_bed").method_10442("has_bed", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8258)).method_36443(finishedRecipeConsumer, string + "_from_white_bed");
    }

    public static void banner(Consumer<class_2444> finishedRecipeConsumer, class_1935 banner, class_1935 material) {
        String string = class_2378.field_11142.method_10221((Object)material.method_8389()).method_12832();
        class_2447.method_10437((class_1935)banner).method_10434(Character.valueOf('#'), material).method_10434(Character.valueOf('|'), (class_1935)class_1802.field_8600).method_10439("###").method_10439("###").method_10439(" | ").method_10435("banner").method_10429("has_" + string, (class_184)PollinatedRecipeProvider.has(material)).method_10431(finishedRecipeConsumer);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 stainedGlass, class_1935 dye) {
        class_2447.method_10436((class_1935)stainedGlass, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10033).method_10434(Character.valueOf('X'), dye).method_10439("###").method_10439("#X#").method_10439("###").method_10435("stained_glass").method_10429("has_glass", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10033)).method_10431(finishedRecipeConsumer);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<class_2444> finishedRecipeConsumer, class_1935 stainedGlassPane, class_1935 stainedGlass) {
        class_2447.method_10436((class_1935)stainedGlassPane, (int)16).method_10434(Character.valueOf('#'), stainedGlass).method_10439("###").method_10439("###").method_10435("stained_glass_pane").method_10429("has_glass", (class_184)PollinatedRecipeProvider.has(stainedGlass)).method_10431(finishedRecipeConsumer);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 stainedGlassPane, class_1935 dye) {
        String string = class_2378.field_11142.method_10221((Object)stainedGlassPane.method_8389()).method_12832();
        String string2 = class_2378.field_11142.method_10221((Object)dye.method_8389()).method_12832();
        class_2447.method_10436((class_1935)stainedGlassPane, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10285).method_10434(Character.valueOf('$'), dye).method_10439("###").method_10439("#$#").method_10439("###").method_10435("stained_glass_pane").method_10429("has_glass_pane", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10285)).method_10429("has_" + string2, (class_184)PollinatedRecipeProvider.has(dye)).method_36443(finishedRecipeConsumer, string + "_from_glass_pane");
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<class_2444> finishedRecipeConsumer, class_1935 coloredTerracotta, class_1935 dye) {
        class_2447.method_10436((class_1935)coloredTerracotta, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10415).method_10434(Character.valueOf('X'), dye).method_10439("###").method_10439("#X#").method_10439("###").method_10435("stained_terracotta").method_10429("has_terracotta", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10415)).method_10431(finishedRecipeConsumer);
    }

    public static void concretePowder(Consumer<class_2444> finishedRecipeConsumer, class_1935 dyedConcretePowder, class_1935 dye) {
        class_2450.method_10448((class_1935)dyedConcretePowder, (int)8).method_10454(dye).method_10449((class_1935)class_2246.field_10102, 4).method_10449((class_1935)class_2246.field_10255, 4).method_10452("concrete_powder").method_10442("has_sand", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10102)).method_10442("has_gravel", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_10255)).method_10431(finishedRecipeConsumer);
    }

    public static void cookRecipes(Consumer<class_2444> finishedRecipeConsumer, String cookingMethod, class_3957<?> cookingSerializer, int cookingTime) {
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8046}), (class_1935)class_1802.field_8176, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_beef", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8046)).method_36443(finishedRecipeConsumer, "cooked_beef_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8726}), (class_1935)class_1802.field_8544, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_chicken", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8726)).method_36443(finishedRecipeConsumer, "cooked_chicken_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429}), (class_1935)class_1802.field_8373, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_cod", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8429)).method_36443(finishedRecipeConsumer, "cooked_cod_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_9993}), (class_1935)class_1802.field_8551, (float)0.1f, (int)cookingTime, cookingSerializer).method_10469("has_kelp", (class_184)PollinatedRecipeProvider.has((class_1935)class_2246.field_9993)).method_36443(finishedRecipeConsumer, "dried_kelp_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8209}), (class_1935)class_1802.field_8509, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_salmon", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8209)).method_36443(finishedRecipeConsumer, "cooked_salmon_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8748}), (class_1935)class_1802.field_8347, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_mutton", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8748)).method_36443(finishedRecipeConsumer, "cooked_mutton_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8389}), (class_1935)class_1802.field_8261, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_porkchop", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8389)).method_36443(finishedRecipeConsumer, "cooked_porkchop_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8567}), (class_1935)class_1802.field_8512, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_potato", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8567)).method_36443(finishedRecipeConsumer, "baked_potato_from_" + cookingMethod);
        class_2454.method_17801((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8504}), (class_1935)class_1802.field_8752, (float)0.35f, (int)cookingTime, cookingSerializer).method_10469("has_rabbit", (class_184)PollinatedRecipeProvider.has((class_1935)class_1802.field_8504)).method_36443(finishedRecipeConsumer, "cooked_rabbit_from_" + cookingMethod);
    }

    public static class_2037.class_2039 insideOf(class_2248 block) {
        return new class_2037.class_2039(class_2048.class_5258.field_24388, block, class_4559.field_20736);
    }

    public static class_2066.class_2068 has(class_1935 itemLike) {
        return PollinatedRecipeProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8977(new class_1935[]{itemLike}).method_8976());
    }

    public static class_2066.class_2068 has(class_3494<class_1792> tag) {
        return PollinatedRecipeProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8975(tag).method_8976());
    }

    public static class_2066.class_2068 inventoryTrigger(class_2073 ... predicate) {
        return new class_2066.class_2068(class_2048.class_5258.field_24388, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, predicate);
    }

    public String method_10321() {
        return "Recipes";
    }
}

