/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedLanguageProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> keys = new TreeMap<String, String>();
    private final class_2403 generator;
    protected final String domain;
    protected final String locale;

    public PollinatedLanguageProvider(class_2403 generator, PollinatedModContainer container, String locale) {
        this.generator = generator;
        this.domain = container.getId();
        this.locale = locale;
    }

    protected abstract void registerTranslations();

    public void method_10319(class_2408 cache) {
        this.registerTranslations();
        Path path = this.generator.method_10313().resolve("assets/" + this.domain + "/lang/" + this.locale + ".json");
        try {
            JsonElement json = GSON.toJsonTree(this.keys);
            class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)json, (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save {}", (Object)path, (Object)e);
        }
    }

    public void addBlock(Supplier<? extends class_2248> key, String name) {
        this.add(key.get().method_9539(), name);
    }

    public void addBlock(class_2248 key, String name) {
        this.add(key.method_9539(), name);
    }

    public void addItem(Supplier<? extends class_1792> key, String name) {
        this.add(key.get().method_7876(), name);
    }

    public void addItem(class_1792 key, String name) {
        this.add(key.method_7876(), name);
    }

    public void addEntityType(Supplier<? extends class_1299<?>> key, String name) {
        this.add(key.get().method_5882(), name);
    }

    public void addEntityType(class_1299<?> key, String name) {
        this.add(key.method_5882(), name);
    }

    public void addItemStack(Supplier<class_1799> key, String name) {
        this.add(key.get().method_7922(), name);
    }

    public void addItemStack(class_1799 key, String name) {
        this.add(key.method_7922(), name);
    }

    public void addEnchantment(Supplier<? extends class_1887> key, String name) {
        this.add(key.get().method_8184(), name);
    }

    public void addEnchantment(class_1887 key, String name) {
        this.add(key.method_8184(), name);
    }

    public void addEffect(Supplier<? extends class_1291> key, String name) {
        this.add(key.get().method_5567(), name);
    }

    public void addEffect(class_1291 key, String name) {
        this.add(key.method_5567(), name);
    }

    public void add(String key, String value) {
        if (this.keys.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public String method_10321() {
        return "Language: " + this.locale;
    }
}

