/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import org.jetbrains.annotations.Nullable;

public class GrindstoneRecipeBuilder {
    private final class_1792 result;
    private final int count;
    private final List<class_1856> ingredients = new ArrayList<class_1856>();
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    private String group;
    private int experience;

    public GrindstoneRecipeBuilder(class_1935 result, int count) {
        this.result = result.method_8389();
        this.count = count;
    }

    public static GrindstoneRecipeBuilder grindstone(class_1935 result) {
        return new GrindstoneRecipeBuilder(result, 1);
    }

    public static GrindstoneRecipeBuilder grindstone(class_1935 result, int count) {
        return new GrindstoneRecipeBuilder(result, count);
    }

    public GrindstoneRecipeBuilder requires(class_3494<class_1792> tag) {
        return this.requires(class_1856.method_8106(tag));
    }

    public GrindstoneRecipeBuilder requires(class_1935 item) {
        return this.requires(item, 1);
    }

    public GrindstoneRecipeBuilder requires(class_1935 item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        return this;
    }

    public GrindstoneRecipeBuilder requires(class_1856 ingredient) {
        return this.requires(ingredient, 1);
    }

    public GrindstoneRecipeBuilder requires(class_1856 ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public GrindstoneRecipeBuilder unlockedBy(String string, class_184 criterionTriggerInstance) {
        this.advancement.method_709(string, criterionTriggerInstance);
        return this;
    }

    public GrindstoneRecipeBuilder group(String string) {
        this.group = string;
        return this;
    }

    public GrindstoneRecipeBuilder experience(int experience) {
        this.experience = experience;
        return this;
    }

    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, class_2378.field_11142.method_10221((Object)this.result));
    }

    public void save(Consumer<class_2444> consumer, String string) {
        class_2960 resourceLocation = class_2378.field_11142.method_10221((Object)this.result);
        if (new class_2960(string).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Grindstone Recipe " + string + " should remove its 'save' argument");
        }
        this.save(consumer, new class_2960(string));
    }

    public void save(Consumer<class_2444> consumer, class_2960 resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)resourceLocation)).method_703(class_170.class_171.method_753((class_2960)resourceLocation)).method_704(class_193.field_1257);
        consumer.accept(new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, this.experience, this.ingredients, this.advancement, new class_2960(resourceLocation.method_12836(), "recipes/" + this.result.method_7859().method_7751() + "/" + resourceLocation.method_12832())));
    }

    private void ensureValid(class_2960 id) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final int experience;
        private final List<class_1856> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 id, class_1792 result, int count, String group, int experience, List<class_1856> ingredients, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.experience = experience;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.experience != 0) {
                json.addProperty("experience", (Number)this.experience);
            }
            JsonArray jsonArray = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                jsonArray.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_2378.field_11142.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public class_1865<?> method_17800() {
            return PollenRecipeTypes.GRINDSTONE.get();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

