/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.config.fabric;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.config.PollinatedModConfig;
import gg.moonflower.pollen.api.config.fabric.ConfigFileTypeHandler;
import gg.moonflower.pollen.api.config.fabric.FabricConfigSpec;
import java.nio.file.Path;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollinatedModConfigImpl
implements PollinatedModConfig {
    private final PollinatedConfigType type;
    private final FabricConfigSpec spec;
    private final String fileName;
    private final ModContainer container;
    private final ConfigFileTypeHandler configHandler;
    private CommentedConfig configData;

    public PollinatedModConfigImpl(PollinatedConfigType type, FabricConfigSpec spec, ModContainer container, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.container = container;
        this.configHandler = ConfigFileTypeHandler.TOML;
    }

    @Override
    public PollinatedConfigType getType() {
        return this.type;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public ConfigFileTypeHandler getHandler() {
        return this.configHandler;
    }

    @Override
    public FabricConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getModId() {
        return this.container.getMetadata().getId();
    }

    @Override
    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.setConfig(this.configData);
    }

    @Override
    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    @Override
    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }
}

