/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.config.fabric;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import gg.moonflower.pollen.api.config.fabric.PollinatedModConfigImpl;
import gg.moonflower.pollen.api.event.events.ConfigEvent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFileTypeHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    static ConfigFileTypeHandler TOML = new ConfigFileTypeHandler();

    public static void backUpConfig(CommentedFileConfig commentedFileConfig) {
        ConfigFileTypeHandler.backUpConfig(commentedFileConfig, 5);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getNioPath().getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFile().getName());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFile().getName()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig.getNioPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to back up config file {}", (Object)commentedFileConfig.getNioPath(), (Object)e);
        }
    }

    public Function<PollinatedModConfigImpl, CommentedFileConfig> reader(Path configBasePath) {
        return config -> {
            Path configPath = configBasePath.resolve(config.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder(configPath).sync().preserveInsertionOrder().autosave().onFileNotFound(this::setupConfigFile).writingMode(WritingMode.REPLACE).build();
            LOGGER.debug("Built TOML config for {}", (Object)configPath.toString());
            try {
                configData.load();
            }
            catch (ParsingException ex) {
                throw new ConfigLoadingException((PollinatedModConfigImpl)config, (Throwable)ex);
            }
            LOGGER.debug("Loaded TOML config file {}", (Object)configPath.toString());
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((PollinatedModConfigImpl)config, configData, Thread.currentThread().getContextClassLoader()));
                LOGGER.debug("Watching TOML config file {} for changes", (Object)configPath.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public void unload(Path configBasePath, PollinatedModConfigImpl config) {
        Path configPath = configBasePath.resolve(config.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(config.getFileName()));
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath.toString(), (Object)e);
        }
    }

    private boolean setupConfigFile(Path file, ConfigFormat<?> conf) throws IOException {
        Files.createFile(file, new FileAttribute[0]);
        conf.initEmptyFile(file);
        return true;
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(PollinatedModConfigImpl config, Throwable cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final PollinatedModConfigImpl modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(PollinatedModConfigImpl modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect(this.commentedFileConfig)) {
                        LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ConfigFileTypeHandler.backUpConfig(this.commentedFileConfig);
                        this.modConfig.getSpec().correct(this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException e) {
                    throw new ConfigLoadingException(this.modConfig, (Throwable)e);
                }
                LOGGER.debug("Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                ConfigEvent.RELOADING.invoker().configChanged(this.modConfig);
            }
        }
    }
}

