/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.command.argument;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import net.minecraft.class_2314;
import net.minecraft.class_2324;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class TimeArgumentType
implements ArgumentType<Long> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0t", "12s", "98h", "4d");
    private static final DynamicCommandExceptionType UNKNOWN_UNIT = new DynamicCommandExceptionType(arg -> new class_2588("argument.pollen.time.unknown_unit", new Object[]{arg}));
    private static final Dynamic2CommandExceptionType TIME_TOO_LOW = new Dynamic2CommandExceptionType((result, min) -> new class_2588("argument.time.pollen.low", new Object[]{min, result}));
    private static final Dynamic2CommandExceptionType TIME_TOO_HIGH = new Dynamic2CommandExceptionType((result, max) -> new class_2588("argument.time.pollen.big", new Object[]{max, result}));
    private static final ImmutableMap<String, Pair<class_2561, LongFunction<Long>>> TIME_UNITS;
    private final long min;
    private final long max;
    private final TimeUnit unit;

    private TimeArgumentType(long min, long max, TimeUnit unit) {
        this.min = min;
        this.max = max;
        this.unit = unit;
    }

    public static TimeArgumentType time() {
        return new TimeArgumentType(Long.MIN_VALUE, Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    public static TimeArgumentType time(long min, long max, TimeUnit unit) {
        return new TimeArgumentType(min, max, unit);
    }

    public static long getTime(CommandContext<?> context, String name) {
        return ((Number)context.getArgument(name, Number.class)).longValue();
    }

    public Long parse(StringReader reader) throws CommandSyntaxException {
        long time = reader.readLong();
        String unit = reader.readUnquotedString();
        if (!TIME_UNITS.containsKey((Object)unit)) {
            throw UNKNOWN_UNIT.createWithContext((ImmutableStringReader)reader, (Object)unit);
        }
        class_2561 unitName = (class_2561)((Pair)TIME_UNITS.get((Object)unit)).getLeft();
        long nanos = (Long)((LongFunction)((Pair)TIME_UNITS.get((Object)unit)).getRight()).apply(time);
        long localNanos = this.unit.convert(nanos, TimeUnit.NANOSECONDS);
        if (localNanos < this.min) {
            throw TIME_TOO_LOW.createWithContext((ImmutableStringReader)reader, (Object)new class_2585(this.min + " ").method_10852(unitName), (Object)new class_2585(localNanos + " ").method_10852(unitName));
        }
        if (localNanos > this.max) {
            throw TIME_TOO_HIGH.createWithContext((ImmutableStringReader)reader, (Object)new class_2585(this.max + " ").method_10852(unitName), (Object)new class_2585(localNanos + " ").method_10852(unitName));
        }
        return nanos;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getRemaining());
        while (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            reader.skip();
        }
        TIME_UNITS.keySet().stream().filter(unit -> reader.getRemaining().isEmpty() || unit.startsWith(reader.getRemaining())).forEach(unit -> builder.suggest(builder.getInput().substring(builder.getStart(), builder.getStart() + reader.getCursor()) + unit, (Message)((Pair)TIME_UNITS.get(unit)).getLeft()));
        return builder.buildFuture();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"ns", (Object)Pair.of((Object)new class_2585("Nanoseconds"), time -> time));
        builder.put((Object)"us", (Object)Pair.of((Object)new class_2585("Microseconds"), time -> time * 1000L));
        builder.put((Object)"ms", (Object)Pair.of((Object)new class_2585("Milliseconds"), time -> time * 1000000L));
        builder.put((Object)"s", (Object)Pair.of((Object)new class_2585("Seconds"), time -> time * 1000000000L));
        builder.put((Object)"m", (Object)Pair.of((Object)new class_2585("Minutes"), time -> time * 60000000000L));
        builder.put((Object)"h", (Object)Pair.of((Object)new class_2585("Hours"), time -> time * 3600000000000L));
        builder.put((Object)"d", (Object)Pair.of((Object)new class_2585("Days"), time -> time * 86400000000000L));
        builder.put((Object)"t", (Object)Pair.of((Object)new class_2585("Game Ticks"), time -> time * 50000000L));
        TIME_UNITS = builder.build();
    }

    @ApiStatus.Internal
    public static class Serializer
    implements class_2314<TimeArgumentType> {
        public void serializeToNetwork(TimeArgumentType argument, class_2540 buf) {
            boolean flag = argument.getMinimum() != Long.MIN_VALUE;
            boolean flag1 = argument.getMaximum() != Long.MAX_VALUE;
            buf.writeByte((int)class_2324.method_10037((boolean)flag, (boolean)flag1));
            if (flag) {
                buf.writeLong(argument.getMinimum());
            }
            if (flag1) {
                buf.writeLong(argument.getMaximum());
            }
            buf.method_10814(argument.unit.name().toLowerCase(Locale.ROOT));
        }

        public TimeArgumentType deserializeFromNetwork(class_2540 buf) {
            byte b0 = buf.readByte();
            long i = class_2324.method_10039((byte)b0) ? buf.readLong() : Long.MIN_VALUE;
            long j = class_2324.method_10038((byte)b0) ? buf.readLong() : Long.MAX_VALUE;
            TimeUnit unit = TimeUnit.valueOf(buf.method_19772().toUpperCase(Locale.ROOT));
            return TimeArgumentType.time(i, j, unit);
        }

        public void serializeToJson(TimeArgumentType argument, JsonObject json) {
            if (argument.getMinimum() != Long.MIN_VALUE) {
                json.addProperty("min", (Number)argument.getMinimum());
            }
            if (argument.getMaximum() != Long.MAX_VALUE) {
                json.addProperty("max", (Number)argument.getMaximum());
            }
            json.addProperty("unit", argument.getUnit().name().toLowerCase(Locale.ROOT));
        }
    }
}

