/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.command.argument;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import org.jetbrains.annotations.ApiStatus;

public class EnumArgument
implements ArgumentType<String> {
    private static final Collection<String> EXAMPLES = Arrays.asList("creative", "survival", "loot_chest", "accessory");
    private static final SimpleCommandExceptionType INVALID_TYPE = new SimpleCommandExceptionType((Message)new class_2588("argument.pollen.enum.invalid"));
    private final String[] values;

    private EnumArgument(String[] values) {
        this.values = values;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumArgument enumValues(Enum<T> ... values) {
        return new EnumArgument((String[])Arrays.stream(values).map(value -> value.name().toLowerCase(Locale.ROOT)).toArray(String[]::new));
    }

    public static <T extends Enum<T>> T getEnum(Class<T> clazz, CommandContext<?> context, String name) throws CommandSyntaxException {
        String value = (String)context.getArgument(name, String.class);
        for (Enum enumValue : (Enum[])clazz.getEnumConstants()) {
            if (!enumValue.name().equalsIgnoreCase(value)) continue;
            return (T)enumValue;
        }
        throw INVALID_TYPE.create();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        for (String value : this.values) {
            if (!value.equalsIgnoreCase(input)) continue;
            return value;
        }
        throw INVALID_TYPE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(Stream.of(this.values), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @ApiStatus.Internal
    public static class Serializer
    implements class_2314<EnumArgument> {
        public void serializeToNetwork(EnumArgument argument, class_2540 buf) {
            buf.method_10804(argument.values.length);
            for (String value : argument.values) {
                buf.method_10814(value);
            }
        }

        public EnumArgument deserializeFromNetwork(class_2540 buf) {
            int length = buf.method_10816();
            String[] values = new String[length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = buf.method_19772();
            }
            return new EnumArgument(values);
        }

        public void serializeToJson(EnumArgument argument, JsonObject json) {
            JsonArray valuesJson = new JsonArray();
            for (String value : argument.values) {
                valuesJson.add(value);
            }
            json.add("values", (JsonElement)valuesJson);
        }
    }
}

