/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.stb.STBImageWrite;

public final class TextureDownloader {
    private TextureDownloader() {
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, int texture) {
        GL11C.glBindTexture((int)3553, (int)texture);
        int base = GL11C.glGetTexParameteri((int)3553, (int)33084);
        int max = GL11C.glGetTexParameteri((int)3553, (int)33085);
        if (max == 1000) {
            max = 0;
        }
        ArrayList<CompletableFuture<Void>> result = new ArrayList<CompletableFuture<Void>>(max - base + 1);
        for (int level = base; level <= max; ++level) {
            Path outputFile = outputFolder.resolve(name + (String)(base == max ? "" : "-" + level) + ".png");
            if (!Files.exists(outputFile, new LinkOption[0])) {
                try {
                    Files.createFile(outputFile, new FileAttribute[0]);
                }
                catch (Exception e) {
                    result.add(class_156.method_19483((Throwable)e));
                    continue;
                }
            }
            int width = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
            ByteBuffer image = BufferUtils.createByteBuffer((int)(width * height * 4));
            GL11C.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)image);
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                if (!STBImageWrite.stbi_write_png((CharSequence)outputFile.toString(), (int)width, (int)height, (int)4, (ByteBuffer)image, (int)0)) {
                    throw new CompletionException(new IOException("Failed to write image to: " + outputFile));
                }
            }, class_156.method_27958());
            result.add(future);
        }
        return class_156.method_33791(result);
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, class_1044 texture) {
        return TextureDownloader.save(name, outputFolder, texture.method_4624());
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, class_2960 texture) {
        class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(texture);
        return TextureDownloader.save(name, outputFolder, (class_1044)(abstractTexture != null ? abstractTexture : class_1047.method_4540()));
    }
}

