/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3312;
import net.minecraft.class_3544;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SkinHelper {
    private static final Map<GameProfile, CompletableFuture<GameProfile>> PROFILE_CACHE = new WeakHashMap<GameProfile, CompletableFuture<GameProfile>>();
    private static MinecraftSessionService sessionService;
    private static class_3312 gameProfileCache;

    private SkinHelper() {
    }

    @ApiStatus.Internal
    public static void init() {
        YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(class_310.method_1551().method_1487());
        sessionService = authenticationservice.createMinecraftSessionService();
        gameProfileCache = new class_3312(authenticationservice.createProfileRepository(), new File(class_310.method_1551().field_1697, MinecraftServer.field_4588.getName()));
    }

    private static CompletableFuture<GameProfile> guiUpdateGameProfile(GameProfile input) {
        if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
            return CompletableFuture.completedFuture(input);
        }
        if (class_3544.method_15438((String)input.getName()) && input.getId() == null) {
            return CompletableFuture.completedFuture(input);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (class_3544.method_15438((String)input.getName())) {
                Optional optional = gameProfileCache.method_14512(input.getId());
                if (optional.isEmpty()) {
                    return input;
                }
                GameProfile profile = (GameProfile)optional.get();
                Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    profile = sessionService.fillProfileProperties(profile, true);
                }
                return profile;
            }
            Optional optional = gameProfileCache.method_14515(input.getName());
            if (optional.isEmpty()) {
                return input;
            }
            GameProfile profile = (GameProfile)optional.get();
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                profile = sessionService.fillProfileProperties(profile, true);
            }
            return profile;
        }, class_156.method_18349());
    }

    private static CompletableFuture<GameProfile> updateGameProfileFuture(GameProfile input) {
        CompletableFuture<GameProfile> future = new CompletableFuture<GameProfile>();
        class_2631.method_11335((GameProfile)input, future::complete);
        return future;
    }

    @Nullable
    public static synchronized CompletableFuture<GameProfile> updateGameProfile(@Nullable GameProfile input) {
        if (input == null) {
            return null;
        }
        if (class_310.method_1551().field_1687 == null || class_3544.method_15438((String)input.getName())) {
            return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::guiUpdateGameProfile);
        }
        return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::updateGameProfileFuture);
    }

    public static void loadPlayerTexture(@Nullable GameProfile input, MinecraftProfileTexture.Type type, Consumer<class_2960> consumer) {
        CompletableFuture.runAsync(() -> {
            if (input == null) {
                consumer.accept(class_1068.method_4649());
                return;
            }
            Map map = class_310.method_1551().method_1582().method_4654(input);
            if (map.containsKey(type)) {
                RenderSystem.recordRenderCall(() -> consumer.accept(class_310.method_1551().method_1582().method_4656((MinecraftProfileTexture)map.get(type), type)));
            } else {
                consumer.accept(class_1068.method_4648((UUID)class_1657.method_7271((GameProfile)input)));
            }
        }, class_156.method_18349());
    }
}

