/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class PollinatedSpriteUploader
extends class_4080<class_1059.class_4007>
implements AutoCloseable {
    private final class_1059 textureAtlas;
    private final String prefix;
    private final Set<class_2960> registeredSprites;
    private final Set<Supplier<Collection<class_2960>>> registeredSpriteSuppliers;
    private int mipmapLevels;

    public PollinatedSpriteUploader(class_1060 textureManager, class_2960 textureLocation, String prefix) {
        this.prefix = prefix;
        this.textureAtlas = new class_1059(textureLocation);
        this.registeredSprites = new HashSet<class_2960>();
        this.registeredSpriteSuppliers = new HashSet<Supplier<Collection<class_2960>>>();
        this.mipmapLevels = 0;
        textureManager.method_4616(this.textureAtlas.method_24106(), (class_1044)this.textureAtlas);
    }

    public void registerSprite(class_2960 location) {
        this.registeredSprites.add(location);
    }

    public void registerSpriteSupplier(Supplier<Collection<class_2960>> supplier) {
        this.registeredSpriteSuppliers.add(supplier);
    }

    private Stream<class_2960> getResourceLocations() {
        HashSet<class_2960> locations = new HashSet<class_2960>(this.registeredSprites);
        this.registeredSpriteSuppliers.stream().map(Supplier::get).forEach(locations::addAll);
        return Collections.unmodifiableSet(locations).stream();
    }

    public class_1058 getSprite(class_2960 location) {
        return this.textureAtlas.method_4608(this.resolveLocation(location));
    }

    private class_2960 resolveLocation(class_2960 location) {
        return new class_2960(location.method_12836(), this.prefix + "/" + location.method_12832());
    }

    protected class_1059.class_4007 prepare(class_3300 resourceManager, class_3695 profiler) {
        profiler.method_16065();
        profiler.method_15396("stitching");
        class_1059.class_4007 atlastexture$sheetdata = this.textureAtlas.method_18163(resourceManager, this.getResourceLocations().map(this::resolveLocation), profiler, this.mipmapLevels);
        profiler.method_15407();
        profiler.method_16066();
        return atlastexture$sheetdata;
    }

    protected void apply(class_1059.class_4007 object, class_3300 resourceManager, class_3695 profiler) {
        profiler.method_16065();
        profiler.method_15396("upload");
        this.textureAtlas.method_18159(object);
        profiler.method_15407();
        profiler.method_16066();
    }

    @Override
    public void close() {
        this.textureAtlas.method_4601();
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    public void setMipmapLevels(int mipmapLevels) {
        this.mipmapLevels = Math.max(0, mipmapLevels);
    }
}

